/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.CollectionUtils;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.enterprise.inject.Stereotype;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Query;

public class MethodInvocation {
    private final TypeInfo type;
    private final Method method;
    private final Object[] parameterValues;

    public static MethodInvocation of(Method method, Object ... args) {
        return new MethodInvocation(new TypeInfo(null, method.getDeclaringClass()), method, args);
    }

    private MethodInvocation(TypeInfo type, Method method, Object[] parameterValues) {
        this.type = type;
        this.method = method;
        this.parameterValues = parameterValues;
    }

    public String toString() {
        return this.type + "#" + this.method.getName();
    }

    public String getKey() {
        return this.method.toGenericString();
    }

    public boolean isQuery() {
        return !this.ifAnnotated(Mutation.class).isPresent();
    }

    public String getName() {
        return this.queryName().orElseGet(() -> this.mutationName().orElseGet(this::methodName));
    }

    private Optional<String> queryName() {
        return this.ifAnnotated(Query.class).map(Query::value).filter(CollectionUtils::nonEmpty);
    }

    private Optional<String> mutationName() {
        return this.ifAnnotated(Mutation.class).map(Mutation::value).filter(CollectionUtils::nonEmpty);
    }

    private String methodName() {
        String name = this.method.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    private <T extends Annotation> Optional<T> ifAnnotated(Class<T> type) {
        return Optional.ofNullable(this.method.getAnnotation(type));
    }

    public TypeInfo getReturnType() {
        return new TypeInfo(this.type, this.method.getGenericReturnType(), this.method.getAnnotatedReturnType());
    }

    public boolean hasValueParameters() {
        return this.valueParameters().count() > 0L;
    }

    public Stream<ParameterInfo> valueParameters() {
        return this.parameters().filter(ParameterInfo::isValueParameter);
    }

    public Stream<ParameterInfo> headerParameters() {
        return this.parameters().filter(ParameterInfo::isHeaderParameter);
    }

    private Stream<ParameterInfo> parameters() {
        Parameter[] parameters = this.method.getParameters();
        return IntStream.range(0, parameters.length).mapToObj(i -> new ParameterInfo(this, parameters[i], this.parameterValues[i]));
    }

    public TypeInfo getDeclaringType() {
        return this.type;
    }

    public <A extends Annotation> Stream<A> getResolvedAnnotations(Class<?> declaring, Class<A> type) {
        return Stream.concat(MethodInvocation.resolveAnnotations(this.method, type), this.resolveInheritedAnnotations(declaring, type)).filter(Objects::nonNull);
    }

    private <A extends Annotation> Stream<A> resolveInheritedAnnotations(Class<?> declaring, Class<A> type) {
        Stream<A> stream = MethodInvocation.resolveAnnotations(declaring, type);
        for (Class<?> i : declaring.getInterfaces()) {
            stream = Stream.concat(stream, this.resolveInheritedAnnotations(i, type));
        }
        return stream;
    }

    private static <A extends Annotation> Stream<A> resolveAnnotations(AnnotatedElement annotatedElement, Class<A> type) {
        return Stream.concat(Stream.of(annotatedElement.getAnnotationsByType(type)), MethodInvocation.resolveStereotypes(annotatedElement.getAnnotations(), type));
    }

    private static <A extends Annotation> Stream<A> resolveStereotypes(Annotation[] annotations, Class<A> type) {
        return Stream.of(annotations).map(Annotation::annotationType).filter(annotation -> annotation.isAnnotationPresent(Stereotype.class)).flatMap(a -> MethodInvocation.resolveAnnotations(a, type));
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            if (System.getSecurityManager() == null) {
                this.method.setAccessible(true);
            } else {
                AccessController.doPrivileged(() -> {
                    this.method.setAccessible(true);
                    return null;
                });
            }
            return this.method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new GraphQlClientException("can't invoke " + this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("expected to be unreachable", e);
        }
    }

    public boolean isStatic() {
        return this.is(Modifier::isStatic);
    }

    public boolean isPublic() {
        return this.is(Modifier::isPublic);
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isProtected() {
        return this.is(Modifier::isProtected);
    }

    public boolean isPrivate() {
        return this.is(Modifier::isPrivate);
    }

    private boolean is(Function<Integer, Boolean> f) {
        return f.apply(this.method.getModifiers());
    }

    public boolean isAccessibleFrom(TypeInfo caller) {
        return this.isPublic() || this.isPackagePrivate() && this.type.getPackage().equals(caller.getPackage()) || (this.isPrivate() || this.isProtected()) && caller.isNestedIn(this.getDeclaringType());
    }
}

