/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic;

import io.smallrye.graphql.client.Error;
import io.smallrye.graphql.client.Response;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class ResponseImpl
implements Response {
    private final JsonObject data;
    private final List<Error> errors;
    private Jsonb jsonb;

    public ResponseImpl(JsonObject data, List<Error> errors) {
        this.data = data;
        this.errors = errors;
    }

    public <T> T getObject(Class<T> dataType, String rootField) {
        JsonObject jsonObject = this.data.getJsonObject(rootField);
        return (T)this.getJsonb().fromJson(jsonObject.toString(), dataType);
    }

    public <T> List<T> getList(Class<T> dataType, String rootField) {
        ArrayList result = new ArrayList();
        Object item = this.data.get((Object)rootField);
        if (item instanceof JsonObject) {
            result.add(this.getObject(dataType, rootField));
            return result;
        }
        JsonArray jsonArray = (JsonArray)item;
        jsonArray.forEach(o -> result.add(this.getJsonb().fromJson(o.toString(), dataType)));
        return result;
    }

    public JsonObject getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasError() {
        return this.errors != null;
    }

    public String toString() {
        return "GraphQLResponse{data=" + this.data + ", errors=" + this.errors + ", jsonb=" + this.jsonb + '}';
    }

    private Jsonb getJsonb() {
        if (this.jsonb == null) {
            this.jsonb = JsonbBuilder.create();
        }
        return this.jsonb;
    }
}

