/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.cdi;

import io.smallrye.graphql.client.NamedClient;
import io.smallrye.graphql.client.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class NamedDynamicClients {
    private static final String CONFIG_KEY_URL = "url";
    private static final String CONFIG_KEY_HEADER = "header";
    private Config config;
    private final String DEFAULT_CLIENT_NAME = "default";
    private Map<String, DynamicGraphQLClient> createdClients;

    @PostConstruct
    void initialize() {
        this.createdClients = new HashMap<String, DynamicGraphQLClient>();
        this.config = ConfigProvider.getConfig();
    }

    @Produces
    @Default
    @Dependent
    DynamicGraphQLClient getClient(InjectionPoint ip) {
        NamedClient annotation = (NamedClient)ip.getAnnotated().getAnnotation(NamedClient.class);
        String clientName = annotation != null ? annotation.value() : "default";
        return this.createdClients.computeIfAbsent(clientName, name -> {
            DynamicGraphQLClientBuilder builder = DynamicGraphQLClientBuilder.newBuilder();
            try {
                builder = builder.url(this.getConfigurationValue(clientName, CONFIG_KEY_URL));
            }
            catch (NoSuchElementException e) {
                throw SmallRyeGraphQLClientMessages.msg.urlNotConfiguredForNamedClient(clientName);
            }
            for (Map.Entry<String, String> header : this.getConfigurationValueMap(clientName, CONFIG_KEY_HEADER).entrySet()) {
                builder = builder.header(header.getKey(), header.getValue());
            }
            return builder.build();
        });
    }

    @PreDestroy
    void cleanup() {
        this.createdClients.values().forEach(client -> {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private String getConfigurationValue(String clientName, String configKey) {
        return (String)this.config.getValue(clientName + "/mp-graphql/" + configKey, String.class);
    }

    private Map<String, String> getConfigurationValueMap(String clientName, String configKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : this.config.getPropertyNames()) {
            String prefix;
            if (!propertyName.startsWith(prefix = clientName + "/mp-graphql/" + configKey + "/")) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)this.config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

