/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.cdi;

import io.smallrye.graphql.client.GraphQLClient;
import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class NamedDynamicClients {
    private final String DEFAULT_CLIENT_NAME = "default";
    @Inject
    GraphQLClientsConfiguration globalConfig;
    private Map<String, DynamicGraphQLClient> createdClients;

    @PostConstruct
    void initialize() {
        this.createdClients = new HashMap<String, DynamicGraphQLClient>();
    }

    @Produces
    @Default
    @Dependent
    DynamicGraphQLClient getClient(InjectionPoint ip) {
        GraphQLClient annotation = (GraphQLClient)ip.getAnnotated().getAnnotation(GraphQLClient.class);
        String clientName = annotation != null ? annotation.value() : "default";
        return this.createdClients.computeIfAbsent(clientName, name -> {
            GraphQLClientConfiguration config = this.globalConfig.getClients().get(name);
            if (config == null || config.getUrl() == null) {
                throw SmallRyeGraphQLClientMessages.msg.urlNotConfiguredForNamedClient(clientName);
            }
            DynamicGraphQLClientBuilder builder = DynamicGraphQLClientBuilder.newBuilder();
            builder = builder.url(config.getUrl());
            for (Map.Entry<String, String> headers : config.getHeaders().entrySet()) {
                builder = builder.header(headers.getKey(), headers.getValue());
            }
            return builder.build();
        });
    }

    @PreDestroy
    void cleanup() {
        this.createdClients.values().forEach(client -> {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

