/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client;

import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.TypesafeClientConfigurationReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class GraphQLClientsConfiguration {
    private Map<String, GraphQLClientConfiguration> clients;
    private static Map<ClassLoader, List<Class<?>>> apis = new WeakHashMap();
    private static boolean singleApplication = false;

    @PostConstruct
    void initialize() {
        this.clients = new HashMap<String, GraphQLClientConfiguration>();
        List<Class<Object>> classes = apis.get(singleApplication ? null : Thread.currentThread().getContextClassLoader());
        if (classes == null) {
            SmallRyeGraphQLClientLogging.log.apisNotSet();
            classes = Collections.emptyList();
        }
        for (Class<?> api : classes) {
            TypesafeClientConfigurationReader configReader = new TypesafeClientConfigurationReader(api);
            this.clients.put(configReader.getConfigKey(), configReader.getClientConfiguration());
        }
        ArrayList<String> detectedClientNames = new ArrayList<String>();
        Config mpConfig = ConfigProvider.getConfig();
        for (String propertyName : mpConfig.getPropertyNames()) {
            String key;
            if (!propertyName.matches("^[A-Za-z0-9-_]+/mp-graphql/.+$") || this.clients.containsKey(key = propertyName.substring(0, propertyName.indexOf("/mp-graphql")))) continue;
            detectedClientNames.add(key);
        }
        for (String clientName : detectedClientNames) {
            GraphQLClientConfiguration configuration = new GraphQLClientConfiguration();
            configuration.setUrl((String)mpConfig.getValue(clientName + "/mp-graphql/url", String.class));
            configuration.setHeaders(this.getConfigurationValueMap(clientName, "header", mpConfig));
            this.clients.put(clientName, configuration);
        }
    }

    public Map<String, GraphQLClientConfiguration> getClients() {
        return this.clients;
    }

    public static void apiClasses(List<Class<?>> apiList, boolean singleApplication) {
        GraphQLClientsConfiguration.singleApplication = singleApplication;
        apis.put(GraphQLClientsConfiguration.singleApplication ? null : Thread.currentThread().getContextClassLoader(), apiList);
    }

    private Map<String, String> getConfigurationValueMap(String clientName, String configKey, Config config) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : config.getPropertyNames()) {
            String prefix;
            if (!propertyName.startsWith(prefix = clientName + "/mp-graphql/" + configKey + "/")) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

