/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client;

import io.smallrye.graphql.client.Error;
import io.smallrye.graphql.client.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.dynamic.ErrorImpl;
import io.smallrye.graphql.client.dynamic.ResponseImpl;
import io.smallrye.graphql.client.dynamic.SmallRyeGraphQLDynamicClientLogging;
import io.smallrye.graphql.client.dynamic.SmallRyeGraphQLDynamicClientMessages;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class ResponseReader {
    public static ResponseImpl readFrom(String input) {
        JsonObject jsonResponse;
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(input));
        try {
            jsonResponse = jsonReader.readObject();
        }
        catch (Exception e) {
            throw SmallRyeGraphQLDynamicClientMessages.msg.cannotParseResponse(input);
        }
        JsonObject data = null;
        if (jsonResponse.containsKey((Object)"data")) {
            if (!jsonResponse.isNull("data")) {
                data = jsonResponse.getJsonObject("data");
            } else {
                SmallRyeGraphQLDynamicClientLogging.log.noDataInResponse();
            }
        }
        ArrayList<Error> errors = null;
        if (jsonResponse.containsKey((Object)"errors")) {
            errors = new ArrayList<Error>();
            for (JsonValue error : jsonResponse.getJsonArray("errors")) {
                JsonObject errorObject = error.asJsonObject();
                ErrorImpl decodedError = new ErrorImpl();
                if (errorObject.containsKey((Object)"message")) {
                    decodedError.setMessage(errorObject.getString("message"));
                }
                if (errorObject.containsKey((Object)"locations")) {
                    JsonArray locations = errorObject.getJsonArray("locations");
                    ArrayList<Map<String, Integer>> locationList = new ArrayList<Map<String, Integer>>();
                    for (JsonValue jsonValue : locations) {
                        JsonObject location = jsonValue.asJsonObject();
                        HashMap map = new HashMap();
                        location.forEach((key, value) -> map.put(key, ((JsonNumber)value).intValue()));
                        locationList.add(map);
                    }
                    decodedError.setLocations(locationList);
                }
                if (errorObject.containsKey((Object)"path")) {
                    Object[] path = new Object[errorObject.getJsonArray("path").size()];
                    int i = 0;
                    for (JsonValue segment : errorObject.getJsonArray("path")) {
                        switch (segment.getValueType()) {
                            case STRING: {
                                path[i] = ((JsonString)segment).getString();
                                break;
                            }
                            case NUMBER: {
                                path[i] = ((JsonNumber)segment).intValue();
                                break;
                            }
                            default: {
                                SmallRyeGraphQLClientLogging.log.unknownPathSegmentType(segment.getValueType());
                            }
                        }
                        ++i;
                    }
                    decodedError.setPath(path);
                }
                if (errorObject.containsKey((Object)"extensions")) {
                    JsonObject extensions = errorObject.getJsonObject("extensions");
                    HashMap<String, Object> extensionMap = new HashMap<String, Object>();
                    extensions.forEach((key, value) -> {
                        switch (value.getValueType()) {
                            case STRING: {
                                extensionMap.put((String)key, ((JsonString)value).getString());
                                break;
                            }
                            case NUMBER: {
                                extensionMap.put((String)key, ((JsonNumber)value).longValue());
                                break;
                            }
                            case FALSE: {
                                extensionMap.put((String)key, false);
                                break;
                            }
                            case TRUE: {
                                extensionMap.put((String)key, true);
                                break;
                            }
                            case NULL: {
                                extensionMap.put((String)key, null);
                                break;
                            }
                            default: {
                                SmallRyeGraphQLClientLogging.log.unknownExtensionType(value.getValueType());
                            }
                        }
                    });
                    decodedError.setExtensions(extensionMap);
                }
                HashMap<String, JsonValue> otherFields = new HashMap<String, JsonValue>();
                for (String key2 : errorObject.keySet()) {
                    if (key2.equals("extensions") || key2.equals("locations") || key2.equals("message") || key2.equals("path")) continue;
                    otherFields.put(key2, (JsonValue)errorObject.get((Object)key2));
                }
                if (!otherFields.isEmpty()) {
                    decodedError.setOtherFields(otherFields);
                }
                errors.add(decodedError);
            }
        }
        return new ResponseImpl(data, errors);
    }
}

