/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic;

import io.smallrye.graphql.client.Request;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class RequestImpl
implements Request {
    private final String document;
    private Map<String, Object> variables;
    private String operationName;

    public RequestImpl(String document) {
        this.document = document;
        this.variables = new HashMap<String, Object>();
    }

    public String toJson() {
        JsonObjectBuilder queryBuilder = Json.createObjectBuilder().add("query", this.document);
        if (!this.variables.isEmpty()) {
            queryBuilder.add("variables", (JsonValue)this._formatJsonVariables());
        }
        if (this.operationName != null && !this.operationName.isEmpty()) {
            queryBuilder.add("operationName", this.operationName);
        }
        return queryBuilder.build().toString();
    }

    private JsonObject _formatJsonVariables() {
        JsonObjectBuilder varBuilder = Json.createObjectBuilder();
        this.variables.forEach((k, v) -> {
            if (v instanceof String) {
                varBuilder.add(k, (String)v);
            } else if (v instanceof Integer) {
                varBuilder.add(k, ((Integer)v).intValue());
            }
        });
        return varBuilder.build();
    }

    public String getDocument() {
        return this.document;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Object getVariable(String key) {
        return this.variables.get(key);
    }

    public Request setVariable(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Request resetVariables() {
        this.variables.clear();
        return this;
    }

    public String toString() {
        return "GraphQLRequest{document=" + this.document + ", variables=" + this.variables + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestImpl other = (RequestImpl)obj;
        if (!Objects.equals(this.document, other.document)) {
            return false;
        }
        return Objects.equals(this.variables, other.variables);
    }
}

