/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic;

import io.smallrye.graphql.client.Error;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class ResponseImpl
implements Response {
    private final JsonObject data;
    private final List<Error> errors;

    public ResponseImpl(JsonObject data, List<Error> errors) {
        this.data = data;
        this.errors = errors;
    }

    public <T> T getObject(Class<T> dataType, String rootField) {
        JsonObject jsonObject = this.data.getJsonObject(rootField);
        return (T)JsonReader.readJson(rootField, TypeInfo.of(dataType), (JsonValue)jsonObject, null);
    }

    public <T> List<T> getList(Class<T> dataType, String rootField) {
        ArrayList result = new ArrayList();
        Object item = this.data.get((Object)rootField);
        if (item instanceof JsonObject) {
            result.add(this.getObject(dataType, rootField));
            return result;
        }
        JsonArray jsonArray = (JsonArray)item;
        TypeInfo type = TypeInfo.of(dataType);
        jsonArray.forEach(o -> result.add(JsonReader.readJson(rootField, type, o, null)));
        return result;
    }

    public JsonObject getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasError() {
        return this.errors != null;
    }

    public String toString() {
        return "GraphQLResponse{data=" + this.data + ", errors=" + this.errors + '}';
    }
}

