/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.GraphQLClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Stack;
import java.util.stream.Collectors;

public class QueryBuilder {
    private final MethodInvocation method;
    private final Stack<String> typeStack = new Stack();
    private final Stack<String> expressionStack = new Stack();

    public QueryBuilder(MethodInvocation method) {
        this.method = method;
    }

    public String build() {
        StringBuilder request = new StringBuilder();
        request.append(this.method.isQuery() ? "query " : "mutation ");
        request.append(this.method.getName());
        if (this.method.hasValueParameters()) {
            request.append(this.method.valueParameters().map(this::declare).collect(Collectors.joining(", ", "(", ")")));
        }
        if (this.method.isSingle()) {
            request.append(" { ");
            request.append(this.method.getName());
            if (this.method.hasRootParameters()) {
                request.append(this.method.rootParameters().map(this::bind).collect(Collectors.joining(", ", "(", ")")));
            }
        }
        request.append(this.fields(this.method.getReturnType()));
        if (this.method.isSingle()) {
            request.append(" }");
        }
        return request.toString();
    }

    private String declare(ParameterInfo parameter) {
        return "$" + parameter.getRawName() + ": " + parameter.graphQlInputTypeName();
    }

    private String bind(ParameterInfo parameter) {
        return parameter.getName() + ": $" + parameter.getRawName();
    }

    private String fields(TypeInfo type) {
        if (this.typeStack.contains(type.getTypeName())) {
            throw new GraphQLClientException("field recursion found");
        }
        try {
            this.typeStack.push(type.getTypeName());
            String string = this.recursionCheckedFields(type);
            return string;
        }
        finally {
            this.typeStack.pop();
        }
    }

    private String recursionCheckedFields(TypeInfo type) {
        while (type.isOptional() || type.isErrorOr()) {
            type = type.getItemType();
        }
        if (type.isScalar()) {
            return "";
        }
        if (type.isCollection()) {
            return this.fields(type.getItemType());
        }
        return type.fields().map(this::field).collect(Collectors.joining(" ", " {", "}"));
    }

    private String field(FieldInfo field) {
        TypeInfo type = field.getType();
        StringBuilder expression = new StringBuilder();
        field.getAlias().ifPresent(alias -> expression.append((String)alias).append(":"));
        expression.append(field.getName());
        if (!(type.isScalar() || type.isCollection() && type.getItemType().isScalar())) {
            String path = this.nestedExpressionPrefix() + field.getRawName();
            if (this.method.hasNestedParameters(path)) {
                expression.append(this.method.nestedParameters(path).map(this::bind).collect(Collectors.joining(", ", "(", ")")));
            }
            this.expressionStack.push(path);
            expression.append(this.fields(type));
            this.expressionStack.pop();
        }
        return expression.toString();
    }

    private String nestedExpressionPrefix() {
        return this.expressionStack.isEmpty() ? "" : this.expressionStack.peek() + ".";
    }
}

