/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQLClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

public class FieldInfo {
    private final TypeInfo container;
    private final Field field;

    FieldInfo(TypeInfo container, Field field) {
        this.container = container;
        this.field = field;
    }

    public String toString() {
        return "field '" + this.getRawName() + "' in " + this.container;
    }

    public TypeInfo getType() {
        return new TypeInfo(this.container, this.field.getGenericType());
    }

    public String getName() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return this.field.getAnnotation(Name.class).value();
        }
        return this.getRawName();
    }

    public String getRawName() {
        return this.field.getName();
    }

    public Optional<String> getAlias() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return Optional.of(this.getRawName());
        }
        return Optional.empty();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Object get(Object instance) {
        try {
            this.field.setAccessible(true);
            return this.field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQLClientException("can't get field " + this, (Throwable)e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQLClientException("can't set field " + this + " to " + value, (Throwable)e);
        }
    }

    public boolean isNonNull() {
        return this.field.isAnnotationPresent(NonNull.class) || this.getType().isPrimitive();
    }
}

