/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client;

import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.TypesafeClientConfigurationReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class GraphQLClientsConfiguration {
    private static final Map<ClassLoader, GraphQLClientsConfiguration> INSTANCES = new WeakHashMap<ClassLoader, GraphQLClientsConfiguration>();
    private static volatile boolean singleApplication = false;
    private final Map<String, GraphQLClientConfiguration> clients = new HashMap<String, GraphQLClientConfiguration>();

    public static void setSingleApplication(boolean singleApplication) {
        GraphQLClientsConfiguration.singleApplication = singleApplication;
    }

    public static GraphQLClientsConfiguration getInstance() {
        ClassLoader key = singleApplication ? null : Thread.currentThread().getContextClassLoader();
        return INSTANCES.computeIfAbsent(key, x -> new GraphQLClientsConfiguration());
    }

    public GraphQLClientsConfiguration() {
        ArrayList<String> detectedClientNames = new ArrayList<String>();
        Config mpConfig = ConfigProvider.getConfig();
        for (String propertyName : mpConfig.getPropertyNames()) {
            String key;
            if (!propertyName.matches("^[A-Za-z0-9-_.$]+/mp-graphql/.+$") || this.clients.containsKey(key = propertyName.substring(0, propertyName.indexOf("/mp-graphql")))) continue;
            detectedClientNames.add(key);
        }
        for (String clientName : detectedClientNames) {
            GraphQLClientConfiguration configuration = new GraphQLClientConfiguration();
            configuration.setUrl((String)mpConfig.getValue(clientName + "/mp-graphql/url", String.class));
            configuration.setHeaders(this.getConfigurationValueMap(clientName, "header", mpConfig));
            this.clients.put(clientName, configuration);
        }
    }

    public void addTypesafeClientApis(List<Class<?>> apis) {
        if (apis == null) {
            SmallRyeGraphQLClientLogging.log.apisNotSet();
            apis = Collections.emptyList();
        }
        for (Class<?> api : apis) {
            TypesafeClientConfigurationReader configReader = new TypesafeClientConfigurationReader(api);
            this.clients.put(configReader.getConfigKey(), configReader.getClientConfiguration());
        }
    }

    public GraphQLClientConfiguration getClient(String key) {
        return this.clients.get(key);
    }

    public void addClient(String key, GraphQLClientConfiguration config) {
        this.clients.put(key, config);
    }

    private Map<String, String> getConfigurationValueMap(String clientName, String configKey, Config config) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : config.getPropertyNames()) {
            String prefix;
            if (!propertyName.startsWith(prefix = clientName + "/mp-graphql/" + configKey + "/")) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

