/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class TypesafeClientConfigurationReader {
    private final String configKey;
    private final GraphQLClientConfiguration clientConfiguration;

    TypesafeClientConfigurationReader(Class<?> apiClass) {
        GraphQLClientApi annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        this.configKey = annotation != null && !annotation.configKey().isEmpty() ? annotation.configKey() : apiClass.getName();
        this.clientConfiguration = new GraphQLClientConfiguration();
        Config mpConfig = ConfigProvider.getConfig();
        Optional configuredUrl = mpConfig.getOptionalValue(this.configKey + "/mp-graphql/url", String.class);
        if (configuredUrl.isPresent()) {
            this.clientConfiguration.setUrl((String)configuredUrl.get());
        } else if (annotation != null && !annotation.endpoint().isEmpty()) {
            this.clientConfiguration.setUrl(annotation.endpoint());
        }
        this.clientConfiguration.setHeaders(this.getConfigurationValueMap(this.configKey, "header", mpConfig));
    }

    GraphQLClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    String getConfigKey() {
        return this.configKey;
    }

    private Map<String, String> getConfigurationValueMap(String clientName, String configKey, Config config) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : config.getPropertyNames()) {
            String prefix;
            if (!propertyName.startsWith(prefix = clientName + "/mp-graphql/" + configKey + "/")) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

