/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.cdi;

import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.typesafe.cdi.TypesafeGraphQLClientBean;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesafeGraphQLClientExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(TypesafeGraphQLClientExtension.class);
    private final List<Class<?>> apis = new ArrayList();

    public void registerGraphQLClientApis(@Observes @WithAnnotations(value={GraphQLClientApi.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            log.info("register {}", (Object)javaClass.getName());
            this.apis.add(javaClass);
        } else {
            log.error("failed to register", (Throwable)new IllegalArgumentException("a GraphQlClientApi must be an interface: " + javaClass.getName()));
        }
    }

    public void createProxies(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        for (Class<?> api : this.apis) {
            afterBeanDiscovery.addBean(new TypesafeGraphQLClientBean(api));
        }
        GraphQLClientsConfiguration.getInstance().addTypesafeClientApis(this.apis);
    }
}

