/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.impl.TypesafeClientConfigurationReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class GraphQLClientsConfiguration {
    private static final Map<ClassLoader, GraphQLClientsConfiguration> INSTANCES = new WeakHashMap<ClassLoader, GraphQLClientsConfiguration>();
    private static volatile boolean singleApplication = false;
    private final Map<String, GraphQLClientConfiguration> clients = new HashMap<String, GraphQLClientConfiguration>();

    public static void setSingleApplication(boolean singleApplication) {
        GraphQLClientsConfiguration.singleApplication = singleApplication;
    }

    public static GraphQLClientsConfiguration getInstance() {
        ClassLoader key = singleApplication ? null : Thread.currentThread().getContextClassLoader();
        return INSTANCES.computeIfAbsent(key, x -> new GraphQLClientsConfiguration());
    }

    public static void clear() {
        INSTANCES.clear();
    }

    public GraphQLClientsConfiguration() {
        HashSet<String> detectedClientNames = new HashSet<String>();
        Config mpConfig = ConfigProvider.getConfig();
        for (String propertyName : mpConfig.getPropertyNames()) {
            String key;
            if (!propertyName.matches("^[A-Za-z0-9-_.$]+/mp-graphql/.+$") || this.clients.containsKey(key = propertyName.substring(0, propertyName.indexOf("/mp-graphql")))) continue;
            detectedClientNames.add(key);
        }
        for (String clientName : detectedClientNames) {
            GraphQLClientConfiguration configuration = new GraphQLClientConfiguration();
            mpConfig.getOptionalValue(clientName + "/mp-graphql/url", String.class).ifPresent(configuration::setUrl);
            configuration.setHeaders(GraphQLClientsConfiguration.getConfiguredHeaders(clientName, mpConfig));
            this.clients.put(clientName, configuration);
        }
    }

    @Deprecated
    public void addTypesafeClientApis(List<Class<?>> apis) {
        if (apis == null) {
            SmallRyeGraphQLClientLogging.log.apisNotSet();
            return;
        }
        apis.forEach(this::initTypesafeClientApi);
    }

    public void initTypesafeClientApi(Class<?> api) {
        TypesafeClientConfigurationReader reader = new TypesafeClientConfigurationReader(api);
        this.clients.merge(reader.getConfigKey(), reader.getClientConfiguration(), GraphQLClientConfiguration::merge);
    }

    public GraphQLClientConfiguration getClient(String key) {
        return this.clients.get(key);
    }

    public void addClient(String key, GraphQLClientConfiguration config) {
        this.clients.put(key, config);
    }

    public static Map<String, String> getConfiguredHeaders(String configKey, Config config) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyName : config.getPropertyNames()) {
            String prefix;
            if (!propertyName.startsWith(prefix = configKey + "/mp-graphql/header/")) continue;
            String name = propertyName.substring(prefix.length());
            String value = (String)config.getValue(propertyName, String.class);
            map.put(name, value);
        }
        return map;
    }
}

