/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.impl.typesafe.json.JsonReader;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class ResponseImpl
implements Response {
    private final JsonObject data;
    private final List<GraphQLError> errors;
    private final Map<String, List<String>> headers;

    public ResponseImpl(JsonObject data, List<GraphQLError> errors, Map<String, List<String>> headers) {
        this.data = data;
        this.errors = errors;
        this.headers = Collections.unmodifiableMap(headers != null ? headers : Collections.emptyMap());
    }

    public <T> T getObject(Class<T> dataType, String rootField) {
        if (this.data == null || this.data.equals(JsonValue.NULL) || this.data.keySet().isEmpty()) {
            throw SmallRyeGraphQLClientMessages.msg.noDataInResponse();
        }
        JsonValue value = (JsonValue)this.data.get((Object)rootField);
        if (value == null || value.getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            throw SmallRyeGraphQLClientMessages.msg.fieldNotFoundInResponse(rootField, this.data.keySet());
        }
        if (value.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
            return (T)JsonReader.readJson(rootField, TypeInfo.of(dataType), (JsonValue)value.asJsonObject(), null);
        }
        if (value.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
            throw SmallRyeGraphQLClientMessages.msg.responseContainsArray(rootField);
        }
        Object scalarValue = this.getScalarValue(value);
        if (scalarValue != null) {
            return (T)scalarValue;
        }
        throw SmallRyeGraphQLClientMessages.msg.unexpectedValueInResponse(rootField, value.getValueType().toString());
    }

    public <T> List<T> getList(Class<T> dataType, String rootField) {
        if (this.data == null || this.data.equals(JsonValue.NULL) || this.data.keySet().isEmpty()) {
            throw SmallRyeGraphQLClientMessages.msg.noDataInResponse();
        }
        JsonValue item = (JsonValue)this.data.get((Object)rootField);
        if (item == null) {
            throw SmallRyeGraphQLClientMessages.msg.fieldNotFoundInResponse(rootField, this.data.keySet());
        }
        if (item instanceof JsonObject) {
            throw SmallRyeGraphQLClientMessages.msg.responseContainsSingleObject(rootField);
        }
        if (item instanceof JsonArray) {
            ArrayList result = new ArrayList();
            JsonArray jsonArray = (JsonArray)item;
            TypeInfo type = TypeInfo.of(dataType);
            jsonArray.forEach(o -> {
                if (o.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                    result.add(JsonReader.readJson(rootField, type, o, null));
                } else {
                    result.add(this.getScalarValue((JsonValue)o));
                }
            });
            return result;
        }
        throw SmallRyeGraphQLClientMessages.msg.unexpectedValueInResponse(rootField, item.getValueType().toString());
    }

    private Object getScalarValue(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return ((JsonNumber)value).longValue();
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return null;
    }

    public JsonObject getData() {
        return this.data;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public void throwExceptionIfErrors() {
        if (!this.errors.isEmpty()) {
            throw new GraphQLClientException("Errors from service", this.errors);
        }
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasError() {
        return this.errors != null;
    }

    public String toString() {
        return "GraphQLResponse{data=" + this.data + ", errors=" + this.errors + '}';
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getTransportMeta() {
        return this.headers;
    }
}

