/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.reflection;

import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.json.bind.annotation.JsonbProperty;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

public class FieldInfo {
    private final TypeInfo container;
    private final Field field;
    private final boolean includeIfNull;
    private final String name;
    private static final String JSONB_PROPERTY = "javax.json.bind.annotation.JsonbProperty";
    private static final String JACKSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";

    FieldInfo(TypeInfo container, Field field) {
        this.container = container;
        this.field = field;
        JsonbProperty jsonbPropertyAnnotation = field.getAnnotation(JsonbProperty.class);
        this.includeIfNull = jsonbPropertyAnnotation != null ? jsonbPropertyAnnotation.nillable() : false;
        this.name = this.computeName();
    }

    public String toString() {
        return "field '" + this.getRawName() + "' in " + this.container;
    }

    public TypeInfo getType() {
        return new TypeInfo(this.container, this.field.getGenericType());
    }

    public String getName() {
        return this.name;
    }

    private String computeName() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return this.field.getAnnotation(Name.class).value();
        }
        String jsonbValue = this.getAnnotationByClassName(JSONB_PROPERTY).map(this::getNonEmptyValue).orElse(null);
        if (jsonbValue != null) {
            return jsonbValue;
        }
        String jacksonValue = this.getAnnotationByClassName(JACKSON_PROPERTY).map(this::getNonEmptyValue).orElse(null);
        if (jacksonValue != null) {
            return jacksonValue;
        }
        return this.getRawName();
    }

    private Optional<Annotation> getAnnotationByClassName(String className) {
        return Arrays.stream(this.field.getAnnotations()).filter(a -> a.annotationType().getName().equals(className)).findAny();
    }

    private String getNonEmptyValue(Annotation jsonbProperty) {
        try {
            Method method = jsonbProperty.getClass().getMethod("value", new Class[0]);
            String value = (String)method.invoke((Object)jsonbProperty, new Object[0]);
            return value == null || value.isEmpty() ? null : value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getRawName() {
        return this.field.getName();
    }

    public Optional<String> getAlias() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return Optional.of(this.getRawName());
        }
        return Optional.empty();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Object get(Object instance) {
        try {
            this.field.setAccessible(true);
            return this.field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't get field " + this, e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't set field " + this + " to " + value, e);
        }
    }

    public boolean isNonNull() {
        return this.field.isAnnotationPresent(NonNull.class) || this.getType().isPrimitive();
    }

    public boolean isIncludeNull() {
        return this.includeIfNull;
    }
}

