/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.core.utils;

import io.smallrye.graphql.client.core.exceptions.BuildException;
import io.smallrye.graphql.client.impl.core.EnumImpl;
import io.smallrye.graphql.client.impl.core.InputObjectImpl;
import io.smallrye.graphql.client.impl.core.VariableImpl;
import java.lang.reflect.Array;
import java.time.LocalDate;

public class ValueFormatter {
    public static String format(Object value) throws BuildException {
        if (value == null) {
            return "null";
        }
        if (value instanceof VariableImpl) {
            VariableImpl var = (VariableImpl)value;
            return "$" + var.getName();
        }
        if (value instanceof InputObjectImpl) {
            InputObjectImpl inputObject = (InputObjectImpl)value;
            return inputObject.build();
        }
        if (value instanceof EnumImpl) {
            EnumImpl gqlEnum = (EnumImpl)value;
            return gqlEnum.build();
        }
        if (value.getClass().isArray()) {
            return ValueFormatter._processArray(value);
        }
        if (value instanceof String) {
            return ValueFormatter._getAsQuotedString(String.valueOf(value));
        }
        if (value instanceof Character) {
            return ValueFormatter._getAsQuotedString(String.valueOf(value));
        }
        if (value instanceof LocalDate) {
            return ValueFormatter._getAsQuotedString(String.valueOf(value));
        }
        return value.toString();
    }

    private static String _processArray(Object array) throws BuildException {
        StringBuilder builder = new StringBuilder();
        int length = Array.getLength(array);
        builder.append("[");
        for (int i = 0; i < length; ++i) {
            builder.append(ValueFormatter.format(Array.get(array, i)));
            if (i >= length - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String _getAsQuotedString(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        block5: for (char c : value.toCharArray()) {
            switch (c) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(c);
                    continue block5;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block5;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block5;
                }
                default: {
                    if (c < ' ') {
                        builder.append(String.format("\\u%04x", c));
                        continue block5;
                    }
                    builder.append(c);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }
}

