/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import java.util.List;
import java.util.Map;

public class GraphQLClientConfiguration {
    private String url;
    private Map<String, String> headers;
    private List<String> websocketSubprotocols;
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Integer maxRedirects;
    private Integer subscriptionInitializationTimeout;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public List<String> getWebsocketSubprotocols() {
        return this.websocketSubprotocols;
    }

    public void setWebsocketSubprotocols(List<String> websocketSubprotocols) {
        this.websocketSubprotocols = websocketSubprotocols;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Integer getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(Integer maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public Integer getSubscriptionInitializationTimeout() {
        return this.subscriptionInitializationTimeout;
    }

    public void setSubscriptionInitializationTimeout(Integer subscriptionInitializationTimeout) {
        this.subscriptionInitializationTimeout = subscriptionInitializationTimeout;
    }

    public GraphQLClientConfiguration merge(GraphQLClientConfiguration other) {
        if (other.url != null) {
            this.url = other.url;
        }
        if (this.headers == null) {
            this.headers = other.headers;
        } else if (other.headers != null) {
            other.headers.forEach((key, value) -> this.headers.put((String)key, (String)value));
        }
        if (this.websocketSubprotocols == null) {
            this.websocketSubprotocols = other.websocketSubprotocols;
        } else if (other.websocketSubprotocols != null) {
            for (String subprotocol : other.websocketSubprotocols) {
                if (this.websocketSubprotocols.contains(subprotocol)) continue;
                this.websocketSubprotocols.add(subprotocol);
            }
        }
        if (other.trustStore != null) {
            this.trustStore = other.trustStore;
        }
        if (other.trustStorePassword != null) {
            this.trustStorePassword = other.trustStorePassword;
        }
        if (other.trustStoreType != null) {
            this.trustStoreType = other.trustStoreType;
        }
        if (other.keyStore != null) {
            this.keyStore = other.keyStore;
        }
        if (other.keyStorePassword != null) {
            this.keyStorePassword = other.keyStorePassword;
        }
        if (other.keyStoreType != null) {
            this.keyStoreType = other.keyStoreType;
        }
        if (other.proxyHost != null) {
            this.proxyHost = other.proxyHost;
        }
        if (other.proxyPort != null && other.proxyPort != 0) {
            this.proxyPort = other.proxyPort;
        }
        if (other.proxyUsername != null) {
            this.proxyUsername = other.proxyUsername;
        }
        if (other.proxyPassword != null) {
            this.proxyPassword = other.proxyPassword;
        }
        if (other.maxRedirects != null) {
            this.maxRedirects = other.maxRedirects;
        }
        if (other.subscriptionInitializationTimeout != null) {
            this.subscriptionInitializationTimeout = other.subscriptionInitializationTimeout;
        }
        return this;
    }
}

