/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.impl.GraphQLErrorImpl;
import io.smallrye.graphql.client.impl.ResponseImpl;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientLogging;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class ResponseReader {
    public static ResponseImpl readFrom(String input, Map<String, List<String>> headers) {
        JsonObject jsonResponse;
        if (input == null) {
            throw SmallRyeGraphQLClientMessages.msg.nullResponseBody();
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(input));
        try {
            jsonResponse = jsonReader.readObject();
        }
        catch (Exception e) {
            throw SmallRyeGraphQLClientMessages.msg.cannotParseResponse(input, e);
        }
        JsonObject data = null;
        if (jsonResponse.containsKey((Object)"data")) {
            if (!jsonResponse.isNull("data")) {
                data = jsonResponse.getJsonObject("data");
            } else {
                SmallRyeGraphQLClientLogging.log.noDataInResponse();
            }
        }
        ArrayList<GraphQLError> errors = null;
        if (jsonResponse.containsKey((Object)"errors")) {
            errors = new ArrayList<GraphQLError>();
            for (JsonValue error : jsonResponse.getJsonArray("errors")) {
                errors.add(ResponseReader.readError(error));
            }
        }
        return new ResponseImpl(data, errors, headers);
    }

    public static GraphQLError readError(JsonValue errorJson) {
        JsonObject errorObject = errorJson.asJsonObject();
        GraphQLErrorImpl decodedError = new GraphQLErrorImpl();
        JsonValue message = (JsonValue)errorObject.get((Object)"message");
        if (message instanceof JsonString) {
            decodedError.setMessage(errorObject.getString("message"));
        }
        if (errorObject.containsKey((Object)"locations")) {
            JsonArray locations = errorObject.getJsonArray("locations");
            ArrayList<Map<String, Integer>> locationList = new ArrayList<Map<String, Integer>>();
            for (JsonValue jsonValue : locations) {
                JsonObject location = jsonValue.asJsonObject();
                HashMap map = new HashMap();
                location.forEach((key, value) -> {
                    if (value instanceof JsonNumber) {
                        map.put(key, ((JsonNumber)value).intValue());
                    }
                });
                locationList.add(map);
            }
            decodedError.setLocations(locationList);
        }
        if (errorObject.containsKey((Object)"path") && ((JsonValue)errorObject.get((Object)"path")).getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
            Object[] path = new Object[errorObject.getJsonArray("path").size()];
            int i = 0;
            for (JsonValue segment : errorObject.getJsonArray("path")) {
                switch (segment.getValueType()) {
                    case STRING: {
                        path[i] = ((JsonString)segment).getString();
                        break;
                    }
                    case NUMBER: {
                        path[i] = ((JsonNumber)segment).intValue();
                        break;
                    }
                    default: {
                        SmallRyeGraphQLClientLogging.log.unknownPathSegmentType(segment.getValueType());
                    }
                }
                ++i;
            }
            decodedError.setPath(path);
        }
        if (errorObject.containsKey((Object)"extensions")) {
            JsonObject extensions = errorObject.getJsonObject("extensions");
            HashMap<String, Object> extensionMap = new HashMap<String, Object>();
            extensions.forEach((key, value) -> extensionMap.put((String)key, ResponseReader.decode(value)));
            decodedError.setExtensions(extensionMap);
        } else {
            decodedError.setExtensions(Collections.emptyMap());
        }
        HashMap<String, Object> otherFields = new HashMap<String, Object>();
        for (String key2 : errorObject.keySet()) {
            if (key2.equals("extensions") || key2.equals("locations") || key2.equals("message") || key2.equals("path")) continue;
            otherFields.put(key2, ResponseReader.decode((JsonValue)errorObject.get((Object)key2)));
        }
        if (!otherFields.isEmpty()) {
            decodedError.setOtherFields(otherFields);
        }
        return decodedError;
    }

    private static Object decode(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).longValue();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case NULL: {
                return null;
            }
        }
        return value;
    }
}

