/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.core;

import io.smallrye.graphql.client.core.FieldOrFragment;
import io.smallrye.graphql.client.core.exceptions.BuildException;
import io.smallrye.graphql.client.impl.core.AbstractOperation;
import io.smallrye.graphql.client.impl.core.VariableImpl;

public class OperationImpl
extends AbstractOperation {
    public String build() {
        StringBuilder builder = new StringBuilder();
        switch (this.getType()) {
            case QUERY: {
                builder.append("query");
                break;
            }
            case MUTATION: {
                builder.append("mutation");
                break;
            }
            case SUBSCRIPTION: {
                builder.append("subscription");
                break;
            }
            default: {
                throw new BuildException("Operation type must be one of QUERY, MUTATION or SUBSCRIPTION");
            }
        }
        builder.append(" ");
        builder.append(this.getName());
        if (!this.getVariables().isEmpty()) {
            this._buildVariables(builder);
        }
        if (this.getFields().isEmpty()) {
            throw new BuildException("An operation must have at least one root field.");
        }
        this._buildFields(builder);
        return builder.toString();
    }

    private void _buildVariables(StringBuilder builder) {
        builder.append("(");
        VariableImpl[] vars = this.getVariables().toArray(new VariableImpl[0]);
        for (int i = 0; i < vars.length; ++i) {
            VariableImpl variable = vars[i];
            builder.append(variable.build());
            if (i >= vars.length - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
    }

    private void _buildFields(StringBuilder builder) {
        builder.append("{");
        FieldOrFragment[] rootFields = this.getFields().toArray(new FieldOrFragment[0]);
        for (int i = 0; i < rootFields.length; ++i) {
            FieldOrFragment rootField = rootFields[i];
            builder.append(rootField.build());
            if (i >= rootFields.length - 1) continue;
            builder.append(" ");
        }
        builder.append("}");
    }
}

