/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe;

import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.ParameterInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class QueryBuilder {
    private final MethodInvocation method;
    private final Stack<String> typeStack = new Stack();
    private final Stack<String> expressionStack = new Stack();

    public QueryBuilder(MethodInvocation method) {
        this.method = method;
    }

    public String build() {
        StringBuilder request = new StringBuilder();
        switch (this.method.getOperationType()) {
            case QUERY: {
                request.append("query ");
                break;
            }
            case MUTATION: {
                request.append("mutation ");
                break;
            }
            case SUBSCRIPTION: {
                request.append("subscription ");
            }
        }
        request.append(this.method.getName());
        if (this.method.hasValueParameters()) {
            request.append(this.method.valueParameters().map(this::declare).collect(Collectors.joining(", ", "(", ")")));
        }
        if (this.method.isSingle()) {
            request.append(" { ");
            request.append(this.method.getName());
            if (this.method.hasRootParameters()) {
                request.append(this.method.rootParameters().map(this::bind).collect(Collectors.joining(", ", "(", ")")));
            }
        }
        request.append(this.fields(this.method.getReturnType()));
        if (this.method.isSingle()) {
            request.append(" }");
        }
        return request.toString();
    }

    private String declare(ParameterInfo parameter) {
        return "$" + parameter.getRawName() + ": " + parameter.graphQlInputTypeName();
    }

    private String bind(ParameterInfo parameter) {
        return parameter.getName() + ": $" + parameter.getRawName();
    }

    private String fields(TypeInfo type) {
        if (this.typeStack.contains(type.getTypeName())) {
            throw SmallRyeGraphQLClientMessages.msg.fieldRecursionFound();
        }
        try {
            this.typeStack.push(type.getTypeName());
            String string = this.recursionCheckedFields(type);
            return string;
        }
        finally {
            this.typeStack.pop();
        }
    }

    private String recursionCheckedFields(TypeInfo type) {
        while (type.isOptional() || type.isErrorOr()) {
            type = type.getItemType();
        }
        if (type.isScalar()) {
            return "";
        }
        if (type.isCollection() || type.isAsync()) {
            return this.fields(type.getItemType());
        }
        if (type.isMap()) {
            String keyFields = this.fields(type.getKeyType());
            String valueFields = this.fields(type.getValueType());
            return "{ key " + keyFields + " value " + valueFields + "}";
        }
        return type.fields().map(this::field).collect(Collectors.joining(" ", " {", "}"));
    }

    private String field(FieldInfo field) {
        TypeInfo type = field.getType();
        StringBuilder expression = new StringBuilder();
        field.getAlias().ifPresent(alias -> expression.append((String)alias).append(":"));
        expression.append(field.getName());
        String path = this.nestedExpressionPrefix() + field.getRawName();
        List<ParameterInfo> nestedParameters = this.method.nestedParameters(path);
        if (!nestedParameters.isEmpty()) {
            expression.append(nestedParameters.stream().map(this::bind).collect(Collectors.joining(", ", "(", ")")));
        }
        this.expressionStack.push(path);
        expression.append(this.fields(type));
        this.expressionStack.pop();
        return expression.toString();
    }

    private String nestedExpressionPrefix() {
        return this.expressionStack.isEmpty() ? "" : this.expressionStack.peek() + ".";
    }
}

