/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractBean<T>
implements Bean<T> {
    protected final Class<T> type;

    public AbstractBean(Class<T> type) {
        this.type = type;
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<AnnotationLiteral>(Arrays.asList(new AnnotationLiteral<Default>(){}, new AnnotationLiteral<Any>(){}));
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.type);
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> ctx) {
        ctx.release();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.type.getName() + " with " + this.getQualifiers();
    }
}

