/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.reflection;

import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.NamedElement;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.typesafe.api.Header;
import io.smallrye.graphql.client.typesafe.api.NestedParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.Id;
import org.eclipse.microprofile.graphql.Input;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

public class ParameterInfo
implements NamedElement {
    private final MethodInvocation method;
    private final Parameter parameter;
    private final TypeInfo type;
    private final Object value;

    public ParameterInfo(MethodInvocation method, Parameter parameter, Object value, Type genericParameterType) {
        this.method = method;
        this.parameter = parameter;
        this.type = new TypeInfo(null, parameter.getType(), parameter.getAnnotatedType(), genericParameterType);
        this.value = value;
    }

    public String toString() {
        return "parameter '" + this.parameter.getName() + "' in " + this.method;
    }

    public String graphQlInputTypeName() {
        if (this.parameter.isAnnotationPresent(Id.class)) {
            if (this.type.isCollection()) {
                return "[ID" + this.optionalExclamationMark(this.type.getItemType()) + "]" + this.optionalExclamationMark(this.type);
            }
            return "ID" + this.optionalExclamationMark(this.type);
        }
        if (this.type.isCollection()) {
            return "[" + this.withExclamationMark(this.type.getItemType()) + "]" + this.optionalExclamationMark(this.type);
        }
        if (this.type.isMap()) {
            return "[Entry_" + this.withExclamationMark(this.type.getKeyType()) + "_" + this.withExclamationMark(this.type.getValueType()) + "Input]" + this.optionalExclamationMark(this.type);
        }
        return this.withExclamationMark(this.type);
    }

    private String withExclamationMark(TypeInfo itemType) {
        return this.graphQlInputTypeName(itemType) + this.optionalExclamationMark(itemType);
    }

    private String graphQlInputTypeName(TypeInfo type) {
        String value;
        if (type.isAnnotated(Input.class) && !(value = type.getAnnotation(Input.class).value()).isEmpty()) {
            return value;
        }
        if (type.isAnnotated(Name.class)) {
            return type.getAnnotation(Name.class).value();
        }
        switch (type.getSimpleName()) {
            case "int": 
            case "Integer": 
            case "short": 
            case "Short": 
            case "byte": 
            case "Byte": 
            case "OptionalInt": {
                return "Int";
            }
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "OptionalDouble": {
                return "Float";
            }
            case "String": 
            case "char": 
            case "Character": 
            case "UUID": {
                return "String";
            }
            case "boolean": 
            case "Boolean": {
                return "Boolean";
            }
            case "BigInteger": 
            case "long": 
            case "Long": 
            case "OptionalLong": {
                return "BigInteger";
            }
            case "BigDecimal": {
                return "BigDecimal";
            }
            case "LocalDate": {
                return "Date";
            }
            case "LocalTime": 
            case "OffsetTime": {
                return "Time";
            }
            case "LocalDateTime": 
            case "OffsetDateTime": 
            case "ZonedDateTime": 
            case "Instant": {
                return "DateTime";
            }
        }
        return type.getSimpleName() + (type.isScalar() || type.isEnum() ? "" : "Input");
    }

    private String optionalExclamationMark(TypeInfo itemType) {
        if (itemType == this.type) {
            return this.type.isPrimitive() || this.parameter.isAnnotationPresent(NonNull.class) ? "!" : "";
        }
        return itemType.isNonNull() ? "!" : "";
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        if (this.parameter.isAnnotationPresent(Name.class)) {
            return this.parameter.getAnnotation(Name.class).value();
        }
        if (!this.parameter.isNamePresent()) {
            throw new RuntimeException("Missing name information for " + this + ".\nYou can either annotate all parameters with @Name, or compile your source code with the -parameters options, so the parameter names are compiled into the class file and available at runtime.");
        }
        return this.getRawName();
    }

    @Override
    public String getRawName() {
        return this.parameter.getName();
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> type) {
        return this.parameter.getAnnotationsByType(type);
    }

    public boolean isHeaderParameter() {
        return this.parameter.isAnnotationPresent(Header.class);
    }

    public boolean isValueParameter() {
        return this.isRootParameter() || this.isNestedParameter();
    }

    public boolean isRootParameter() {
        return !this.isHeaderParameter() && !this.isNestedParameter();
    }

    public boolean isNestedParameter() {
        return this.parameter.isAnnotationPresent(NestedParameter.class);
    }

    public Stream<String> getNestedParameterNames() {
        return Stream.of(this.parameter.getAnnotation(NestedParameter.class).value());
    }
}

