/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.mutiny.Uni;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class TypesafeClientConfigurationReader {
    private final GraphQLClientApi annotation;
    private final Config mpConfig;
    private final String configKey;
    private final GraphQLClientConfiguration clientConfiguration = new GraphQLClientConfiguration();

    TypesafeClientConfigurationReader(Class<?> apiClass) {
        this.annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        this.configKey = this.annotation != null && !this.annotation.configKey().isEmpty() ? this.annotation.configKey() : apiClass.getName();
        this.mpConfig = ConfigProvider.getConfig();
        this.buildUrl();
        this.buildHeaders();
    }

    private void buildUrl() {
        Optional configuredUrl = this.mpConfig.getOptionalValue(this.configKey + "/mp-graphql/url", String.class);
        if (configuredUrl.isPresent()) {
            this.clientConfiguration.setUrl((String)configuredUrl.get());
        } else if (this.annotation != null && !this.annotation.endpoint().isEmpty()) {
            this.clientConfiguration.setUrl(this.annotation.endpoint());
        }
    }

    private void buildHeaders() {
        this.clientConfiguration.setHeaders(GraphQLClientsConfiguration.getConfiguredHeaders(this.configKey, this.mpConfig));
        this.clientConfiguration.setDynamicHeaders(new HashMap<String, Uni<String>>());
    }

    GraphQLClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    String getConfigKey() {
        return this.configKey;
    }
}

