/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.discovery;

import io.smallrye.graphql.client.impl.discovery.ServiceURLSupplier;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Stork;
import java.net.URI;
import org.jboss.logging.Logger;

public class StorkServiceURLSupplier
implements ServiceURLSupplier {
    private final Stork stork;
    private final String serviceName;
    private final String scheme;
    private final String path;
    private final Logger LOG = Logger.getLogger(StorkServiceURLSupplier.class);

    public StorkServiceURLSupplier(URI uri, boolean websocket) {
        if (uri == null || !uri.getScheme().equals("stork") && !uri.getScheme().equals("storks")) {
            throw new IllegalArgumentException("Not a stork URI: " + String.valueOf(uri));
        }
        try {
            this.stork = Stork.getInstance();
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new IllegalStateException("Cannot use URI " + String.valueOf(uri) + " because SmallRye Stork dependency seems to be missing", ncdfe);
        }
        this.serviceName = uri.getHost();
        this.scheme = uri.getScheme().equals("storks") ? (websocket ? "wss" : "https") : (websocket ? "ws" : "http");
        this.path = uri.getPath() + (String)(uri.getRawQuery() == null ? "" : "?" + uri.getRawQuery());
    }

    @Override
    public Uni<String> get() {
        return this.stork.getService(this.serviceName).selectInstance().onItem().transform(i -> {
            String s = this.scheme + "://" + i.getHost() + ":" + i.getPort() + this.path;
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Using URI: " + s));
            }
            return s;
        });
    }
}

