/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.json;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.typesafe.CollectionUtils;
import io.smallrye.graphql.client.impl.typesafe.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.impl.typesafe.json.IndexedLocationBuilder;
import io.smallrye.graphql.client.impl.typesafe.json.JsonReader;
import io.smallrye.graphql.client.impl.typesafe.json.Location;
import io.smallrye.graphql.client.impl.typesafe.json.Reader;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class JsonArrayReader
extends Reader<JsonArray> {
    private Class<?> collectionType;
    private TypeInfo itemType;

    JsonArrayReader(TypeInfo type, Location location, JsonArray value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        GraphQLClientValueHelper.check(this.location, this.value, this.type.isCollection());
        IndexedLocationBuilder locationBuilder = new IndexedLocationBuilder(this.location);
        return ((JsonArray)this.value).stream().map(item -> this.readItem(locationBuilder, (JsonValue)item)).collect(this.collector());
    }

    private Object readItem(IndexedLocationBuilder locationBuilder, JsonValue itemValue) {
        Location itemLocation = locationBuilder.nextLocation();
        TypeInfo it = this.getItemType();
        if (itemValue.getValueType() == JsonValue.ValueType.NULL && it.isNonNull()) {
            throw new InvalidResponseException("invalid null " + String.valueOf(itemLocation));
        }
        return JsonReader.readJson(itemLocation, it, itemValue, this.field);
    }

    private Collector<Object, ?, ?> collector() {
        Class<?> ct = this.getCollectionType();
        if (ct.isArray()) {
            Class<?> rawItemType = this.getItemType().getRawType();
            return CollectionUtils.toArray(rawItemType);
        }
        if (Set.class.isAssignableFrom(ct)) {
            return Collectors.toSet();
        }
        assert (List.class.isAssignableFrom(ct) || ct.equals(Collection.class)) : "collection type " + ct.getName() + " not supported";
        return Collectors.toList();
    }

    private Class<?> getCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = this.type.getRawType();
        }
        return this.collectionType;
    }

    private TypeInfo getItemType() {
        if (this.itemType == null) {
            this.itemType = this.type.getItemType();
        }
        return this.itemType;
    }
}

