/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Array;
import java.util.Optional;
import org.jboss.jandex.Type;

public class ArrayCreator {
    private ArrayCreator() {
    }

    public static Optional<Array> createArray(Type type) {
        return ArrayCreator.createArray(null, type, false);
    }

    public static Optional<Array> createArray(Type type, boolean batched) {
        return ArrayCreator.createArray(null, type, batched);
    }

    public static Optional<Array> createArray(Type fieldType, Type methodType) {
        return ArrayCreator.createArray(fieldType, methodType, false);
    }

    public static Optional<Array> createArray(Type fieldType, Type methodType, boolean batched) {
        if (Classes.isCollectionOrArray(methodType)) {
            if (batched) {
                Type nestedType = (Type)methodType.asParameterizedType().arguments().get(0);
                return ArrayCreator.createArray(nestedType);
            }
            Array.Type arrayType = ArrayCreator.getModelType(methodType);
            int depth = ArrayCreator.getParameterizedDepth(methodType);
            Array array = new Array(methodType.name().toString(), arrayType, depth);
            if (ArrayCreator.markParameterizedTypeNonNull(fieldType, methodType)) {
                array.setNotEmpty(true);
            }
            return Optional.of(array);
        }
        if (Classes.isUnwrappedType(methodType)) {
            Type nestedType = (Type)methodType.asParameterizedType().arguments().get(0);
            return ArrayCreator.createArray(nestedType, batched);
        }
        return Optional.empty();
    }

    private static Array.Type getModelType(Type type) {
        if (type.kind().equals((Object)Type.Kind.ARRAY)) {
            return Array.Type.ARRAY;
        }
        return Array.Type.COLLECTION;
    }

    private static int getParameterizedDepth(Type type) {
        return ArrayCreator.getParameterizedDepth(type, 0);
    }

    private static int getParameterizedDepth(Type type, int depth) {
        if (type.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = type.asArrayType().component();
            return ArrayCreator.getParameterizedDepth(typeInArray, ++depth);
        }
        if (Classes.isCollection(type)) {
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            return ArrayCreator.getParameterizedDepth(typeInCollection, ++depth);
        }
        if (Classes.isUnwrappedType(type)) {
            Type nestedType = (Type)type.asParameterizedType().arguments().get(0);
            return ArrayCreator.getParameterizedDepth(nestedType, depth);
        }
        return depth;
    }

    private static boolean markParameterizedTypeNonNull(Type fieldType, Type methodType) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        if (Classes.isCollectionOrArray(fieldType)) {
            Type typeInCollection = ArrayCreator.getTypeInCollection(fieldType);
            Type methodTypeInCollection = ArrayCreator.getTypeInCollection(methodType);
            Annotations annotationsInParameterizedType = Annotations.getAnnotationsForArray(typeInCollection, methodTypeInCollection);
            return NonNullHelper.markAsNonNull(typeInCollection, annotationsInParameterizedType, true);
        }
        return false;
    }

    private static Type getTypeInCollection(Type type) {
        if (Classes.isCollectionOrArray(type)) {
            if (type.kind().equals((Object)Type.Kind.ARRAY)) {
                Type typeInArray = type.asArrayType().component();
                return ArrayCreator.getTypeInCollection(typeInArray);
            }
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            return ArrayCreator.getTypeInCollection(typeInCollection);
        }
        return type;
    }
}

