/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.ArrayCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.MappingHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Array;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.MappingInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.TransformInfo;
import io.smallrye.graphql.schema.model.Type;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class OperationCreator {
    private final ReferenceCreator referenceCreator;
    private final ArgumentCreator argumentCreator;

    public OperationCreator(ReferenceCreator referenceCreator, ArgumentCreator argumentCreator) {
        this.referenceCreator = referenceCreator;
        this.argumentCreator = argumentCreator;
    }

    public Operation createOperation(MethodInfo methodInfo, OperationType operationType, Type type) {
        return this.createOperation(methodInfo, operationType, type, false);
    }

    public Operation createOperation(MethodInfo methodInfo, OperationType operationType, Type type, boolean batched) {
        if (!Modifier.isPublic(methodInfo.flags())) {
            throw new IllegalArgumentException("Method " + methodInfo.declaringClass().name().toString() + "#" + methodInfo.name() + " is used as an operation, but is not public");
        }
        Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
        org.jboss.jandex.Type fieldType = methodInfo.returnType();
        String name = OperationCreator.getOperationName(methodInfo, operationType, annotationsForMethod);
        Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForMethod, fieldType);
        OperationCreator.validateFieldType(methodInfo, operationType);
        Reference reference = this.referenceCreator.createReferenceForOperationField(fieldType, annotationsForMethod);
        Operation operation = new Operation(methodInfo.declaringClass().name().toString(), methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, (String)maybeDescription.orElse(null), reference, operationType);
        if (type != null) {
            operation.setContainingType(new Reference((Reference)type));
        }
        if (NonNullHelper.markAsNonNull(fieldType, annotationsForMethod)) {
            operation.setNotNull(true);
        }
        operation.setArray((Array)ArrayCreator.createArray(fieldType, batched).orElse(null));
        operation.setAsync(Classes.isAsyncType(fieldType));
        operation.setTransformInfo((TransformInfo)FormatHelper.getFormat(fieldType, annotationsForMethod).orElse(null));
        operation.setMappingInfo((MappingInfo)MappingHelper.getMapping((Field)operation, annotationsForMethod).orElse(null));
        operation.setDefaultValue((String)DefaultValueHelper.getDefaultValue(annotationsForMethod).orElse(null));
        List parameters = methodInfo.parameters();
        for (short i = 0; i < parameters.size(); i = (short)(i + 1)) {
            Optional<Argument> maybeArgument = this.argumentCreator.createArgument(operationType, methodInfo, i);
            maybeArgument.ifPresent(arg_0 -> ((Operation)operation).addArgument(arg_0));
        }
        return operation;
    }

    private static void validateFieldType(MethodInfo methodInfo, OperationType operationType) {
        org.jboss.jandex.Type returnType = methodInfo.returnType();
        if (returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return for [" + operationType.name() + "] on method [" + methodInfo.name() + "]");
        }
    }

    private static String getOperationName(MethodInfo methodInfo, OperationType operationType, Annotations annotations) {
        DotName operationAnnotation = OperationCreator.getOperationAnnotation(operationType);
        return annotations.getOneOfTheseMethodAnnotationsValue(operationAnnotation, Annotations.NAME, Annotations.JSONB_PROPERTY).orElse(OperationCreator.getDefaultExecutionTypeName(methodInfo, operationType));
    }

    private static DotName getOperationAnnotation(OperationType operationType) {
        if (operationType.equals((Object)OperationType.Query)) {
            return Annotations.QUERY;
        }
        if (operationType.equals((Object)OperationType.Mutation)) {
            return Annotations.MUTATION;
        }
        return null;
    }

    private static String getDefaultExecutionTypeName(MethodInfo methodInfo, OperationType operationType) {
        String methodName = methodInfo.name();
        if (operationType.equals((Object)OperationType.Query) || operationType.equals((Object)OperationType.Source)) {
            methodName = MethodHelper.getPropertyName(Direction.OUT, methodName);
        } else if (operationType.equals((Object)OperationType.Mutation)) {
            methodName = MethodHelper.getPropertyName(Direction.IN, methodName);
        }
        return methodName;
    }
}

