/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.MappingInfo;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.Optional;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class MappingHelper {
    private static final String CONTRUCTOR_METHOD_NAME = "<init>";

    private MappingHelper() {
    }

    public static boolean shouldCreateTypeInSchema(Annotations annotations) {
        return !MappingHelper.hasAnyMapping(annotations);
    }

    public static Optional<MappingInfo> getMapping(Field field, Annotations annotations) {
        return MappingHelper.getMapping(field.getReference(), annotations);
    }

    public static Optional<MappingInfo> getMapping(Reference r, Annotations annotations) {
        Type type = MappingHelper.getMapTo(annotations);
        if (type != null) {
            ClassInfo classInfo;
            String scalarName = MappingHelper.getScalarName(type);
            Reference reference = Scalars.getScalar((String)scalarName);
            MappingInfo mappingInfo = new MappingInfo(reference);
            String className = r.getClassName();
            if (!r.getType().equals((Object)ReferenceType.SCALAR) && (classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)className))) != null) {
                Type parameter = Type.create((DotName)DotName.createSimple((String)reference.getClassName()), (Type.Kind)Type.Kind.CLASS);
                MethodInfo constructor = classInfo.method(CONTRUCTOR_METHOD_NAME, new Type[]{parameter});
                if (constructor != null) {
                    mappingInfo.setCreate(MappingInfo.Create.CONSTRUCTOR);
                } else {
                    MethodInfo setValueMethod = classInfo.method("setValue", new Type[]{parameter});
                    if (setValueMethod != null) {
                        mappingInfo.setCreate(MappingInfo.Create.SET_VALUE);
                    } else {
                        String staticFromMethodName = "from" + scalarName;
                        MethodInfo staticFromMethod = classInfo.method(staticFromMethodName, new Type[]{parameter});
                        if (staticFromMethod != null) {
                            mappingInfo.setCreate(MappingInfo.Create.STATIC_FROM);
                        }
                    }
                }
            }
            return Optional.of(mappingInfo);
        }
        return Optional.empty();
    }

    private static boolean hasAnyMapping(Annotations annotations) {
        Type type = MappingHelper.getMapTo(annotations);
        return type != null;
    }

    private static String getScalarName(Type type) {
        String className = type.name().withoutPackagePrefix();
        if (className.contains("$")) {
            return className.substring(className.lastIndexOf("$") + 1);
        }
        return className;
    }

    private static Type getMapTo(Annotations annotations) {
        AnnotationValue annotationValue;
        if (annotations != null && annotations.containsOneOfTheseAnnotations(Annotations.TO_SCALAR) && (annotationValue = annotations.getAnnotationValue(Annotations.TO_SCALAR)) != null) {
            return annotationValue.asClass();
        }
        return null;
    }
}

