/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class TypeNameHelper {
    private static final Logger LOG = Logger.getLogger((String)TypeNameHelper.class.getName());
    private static final String INPUT = "Input";

    private TypeNameHelper() {
    }

    public static String getAnyTypeName(ReferenceType referenceType, ClassInfo classInfo, Annotations annotationsForThisClass) {
        return TypeNameHelper.getAnyTypeName(referenceType, classInfo, annotationsForThisClass, null);
    }

    public static String getAnyTypeName(ReferenceType referenceType, ClassInfo classInfo, Annotations annotationsForThisClass, String parametrizedTypeNameExtension) {
        if (Classes.isEnum(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.ENUM, parametrizedTypeNameExtension);
        }
        if (Classes.isInterface(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INTERFACE, parametrizedTypeNameExtension);
        }
        if (referenceType.equals((Object)ReferenceType.TYPE)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.TYPE, parametrizedTypeNameExtension);
        }
        if (referenceType.equals((Object)ReferenceType.INPUT)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INPUT, parametrizedTypeNameExtension, INPUT);
        }
        if (referenceType.equals((Object)ReferenceType.SCALAR)) {
            return classInfo.name().withoutPackagePrefix();
        }
        LOG.warn((Object)("Using default name for " + classInfo.simpleName() + " [" + referenceType.name() + "]"));
        return classInfo.name().withoutPackagePrefix();
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName, String parametrizedTypeNameExtension) {
        return TypeNameHelper.getNameForClassType(classInfo, annotations, typeName, parametrizedTypeNameExtension, null);
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName, String parametrizedTypeNameExtension, String postFix) {
        StringBuilder sb = new StringBuilder();
        if (annotations.containsKeyAndValidValue(typeName)) {
            AnnotationValue annotationValue = annotations.getAnnotationValue(typeName);
            sb.append(annotationValue.asString().trim());
        } else if (annotations.containsKeyAndValidValue(Annotations.NAME)) {
            sb.append(annotations.getAnnotationValue(Annotations.NAME).asString().trim());
        } else {
            sb.append(classInfo.name().local());
        }
        if (parametrizedTypeNameExtension != null) {
            sb.append(parametrizedTypeNameExtension);
        }
        if (postFix != null) {
            sb.append(postFix);
        }
        return sb.toString();
    }

    public static String createParametrizedTypeNameExtension(List<Type> parametrizedTypeArguments) {
        if (parametrizedTypeArguments == null || parametrizedTypeArguments.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Type gp : parametrizedTypeArguments) {
            TypeNameHelper.appendParametrizedArgumet(sb, gp);
        }
        return sb.toString();
    }

    public static String createParametrizedTypeNameExtension(Reference reference) {
        if (reference.getParametrizedTypeArguments() == null || reference.getParametrizedTypeArguments().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Reference gp : reference.getParametrizedTypeArguments().values()) {
            sb.append("_");
            if (gp.getParametrizedTypeArguments() == null || gp.getParametrizedTypeArguments().isEmpty()) {
                sb.append(gp.getClassName().substring(gp.getClassName().lastIndexOf(".") + 1));
                continue;
            }
            sb.append(gp.getName());
        }
        return sb.toString();
    }

    private static final void appendParametrizedArgumet(StringBuilder sb, Type gp) {
        sb.append("_");
        sb.append(gp.name().local());
        if (gp.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            for (Type t : gp.asParameterizedType().arguments()) {
                TypeNameHelper.appendParametrizedArgumet(sb, t);
            }
        }
    }
}

