/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.model.ReferenceType;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class TypeNameHelper {
    private static final Logger LOG = Logger.getLogger((String)TypeNameHelper.class.getName());
    private static final String INPUT = "Input";
    private static final String EMPTY = "";

    private TypeNameHelper() {
    }

    public static String getAnyTypeName(ReferenceType referenceType, ClassInfo classInfo, Annotations annotationsForThisClass) {
        if (Classes.isEnum(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.ENUM);
        }
        if (Classes.isInterface(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INTERFACE);
        }
        if (referenceType.equals((Object)ReferenceType.TYPE)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.TYPE);
        }
        if (referenceType.equals((Object)ReferenceType.INPUT)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INPUT, INPUT);
        }
        if (referenceType.equals((Object)ReferenceType.SCALAR)) {
            return classInfo.name().withoutPackagePrefix();
        }
        LOG.warn((Object)("Using default name for " + classInfo.simpleName() + " [" + referenceType.name() + "]"));
        return classInfo.name().withoutPackagePrefix();
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName) {
        return TypeNameHelper.getNameForClassType(classInfo, annotations, typeName, EMPTY);
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName, String postFix) {
        if (annotations.containsKeyAndValidValue(typeName)) {
            AnnotationValue annotationValue = annotations.getAnnotationValue(typeName);
            return annotationValue.asString().trim();
        }
        if (annotations.containsKeyAndValidValue(Annotations.NAME)) {
            return annotations.getAnnotationValue(Annotations.NAME).asString().trim();
        }
        return classInfo.name().local() + postFix;
    }
}

