/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.model.Transformation;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.Type;

public class FormatHelper {
    private static final String LOCALE = "locale";
    private static final String ISO = "ISO-8601";

    private FormatHelper() {
    }

    public static boolean hasAnyFormatting(Annotations annotations) {
        return FormatHelper.getDateFormat(annotations).isPresent() || FormatHelper.getNumberFormat(annotations).isPresent();
    }

    public static Optional<Transformation> getFormat(Type type, Annotations annotations) {
        if (Classes.isDateLikeTypeOrContainedIn(type)) {
            return FormatHelper.getDateFormat(annotations);
        }
        if (Classes.isNumberLikeTypeOrContainedIn(type)) {
            return FormatHelper.getNumberFormat(annotations);
        }
        return Optional.empty();
    }

    public static Optional<String> getNumberFormatString(Annotations annotations) {
        Optional<AnnotationInstance> numberFormatAnnotation = FormatHelper.getNumberFormatAnnotation(annotations);
        if (numberFormatAnnotation.isPresent()) {
            AnnotationInstance a = numberFormatAnnotation.get();
            return FormatHelper.getFormat(a);
        }
        return Optional.empty();
    }

    public static String getDateFormatString(Annotations annotations, Type type) {
        Optional<Object> format = Optional.empty();
        Optional<AnnotationInstance> dateFormatAnnotation = FormatHelper.getDateFormatAnnotation(annotations);
        if (dateFormatAnnotation.isPresent()) {
            format = FormatHelper.getFormat(dateFormatAnnotation.get());
        }
        if (format.isPresent()) {
            return (String)format.get();
        }
        return ISO;
    }

    private static Optional<Transformation> getNumberFormat(Annotations annotations) {
        Optional<AnnotationInstance> numberFormatAnnotation;
        if (annotations != null && (numberFormatAnnotation = FormatHelper.getNumberFormatAnnotation(annotations)).isPresent()) {
            return FormatHelper.getNumberFormat(numberFormatAnnotation.get());
        }
        return Optional.empty();
    }

    private static Optional<Transformation> getNumberFormat(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            String format = FormatHelper.getStringValue(annotationInstance);
            String locale = FormatHelper.getStringValue(annotationInstance, LOCALE);
            return Optional.of(new Transformation(Transformation.Type.NUMBER, format, locale, FormatHelper.isJsonB(annotationInstance)));
        }
        return Optional.empty();
    }

    private static Optional<Transformation> getDateFormat(Annotations annotations) {
        Optional<AnnotationInstance> dateFormatAnnotation;
        if (annotations != null && (dateFormatAnnotation = FormatHelper.getDateFormatAnnotation(annotations)).isPresent()) {
            return FormatHelper.getDateFormat(dateFormatAnnotation.get());
        }
        return Optional.empty();
    }

    private static Optional<Transformation> getDateFormat(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            String format = FormatHelper.getStringValue(annotationInstance);
            String locale = FormatHelper.getStringValue(annotationInstance, LOCALE);
            return Optional.of(new Transformation(Transformation.Type.DATE, format, locale, FormatHelper.isJsonB(annotationInstance)));
        }
        return Optional.empty();
    }

    private static boolean isJsonB(AnnotationInstance instance) {
        return instance.name().toString().startsWith("javax.json.bind.annotation.");
    }

    private static Optional<AnnotationInstance> getDateFormatAnnotation(Annotations annotations) {
        return annotations.getOneOfTheseAnnotations(Annotations.DATE_FORMAT, Annotations.JSONB_DATE_FORMAT);
    }

    private static Optional<AnnotationInstance> getNumberFormatAnnotation(Annotations annotations) {
        return annotations.getOneOfTheseAnnotations(Annotations.NUMBER_FORMAT, Annotations.JSONB_NUMBER_FORMAT);
    }

    private static Optional<String> getFormat(AnnotationInstance annotationInstance) {
        AnnotationValue locale = annotationInstance.value(LOCALE);
        AnnotationValue format = annotationInstance.value();
        if (format == null && locale == null) {
            return Optional.empty();
        }
        if (format == null) {
            return Optional.of(locale.asString());
        }
        if (locale == null) {
            return Optional.of(format.asString());
        }
        return Optional.of(format.asString() + " " + locale.asString());
    }

    private static String getStringValue(AnnotationInstance annotationInstance) {
        return FormatHelper.getStringValue(annotationInstance.value());
    }

    private static String getStringValue(AnnotationInstance annotationInstance, String name) {
        return FormatHelper.getStringValue(annotationInstance.value(name));
    }

    private static String getStringValue(AnnotationValue annotationValue) {
        String value = null;
        if (annotationValue != null) {
            value = annotationValue.asString();
        }
        return value;
    }
}

