/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ArgumentCreator {
    private final ReferenceCreator referenceCreator;
    private final FieldCreator fieldCreator;
    private static final DotName CONTEXT = DotName.createSimple((String)"io.smallrye.graphql.api.Context");
    private static final Reference CONTEXT_REF = new Reference(CONTEXT.toString(), CONTEXT.toString(), ReferenceType.TYPE);

    public ArgumentCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator) {
        this.referenceCreator = referenceCreator;
        this.fieldCreator = fieldCreator;
    }

    public Optional<Argument> createArgument(Operation operation, MethodInfo methodInfo, short position) {
        if (position >= methodInfo.parameters().size()) {
            throw new SchemaBuilderException("Can not create argument for parameter [" + position + "] on method [" + methodInfo.declaringClass().name() + "#" + methodInfo.name() + "]: method has only " + methodInfo.parameters().size() + " parameters");
        }
        Annotations annotationsForThisArgument = Annotations.getAnnotationsForArgument(methodInfo, position);
        if (IgnoreHelper.shouldIgnore(annotationsForThisArgument)) {
            return Optional.empty();
        }
        Type argumentType = (Type)methodInfo.parameters().get(position);
        String defaultName = methodInfo.parameterName((int)position);
        String name = annotationsForThisArgument.getOneOfTheseAnnotationsValue(Annotations.NAME).orElse(defaultName);
        Reference reference = ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operation) ? this.referenceCreator.createReferenceForSourceArgument(argumentType, annotationsForThisArgument) : (!argumentType.name().equals((Object)CONTEXT) ? this.referenceCreator.createReferenceForOperationArgument(argumentType, annotationsForThisArgument) : CONTEXT_REF);
        Argument argument = new Argument(defaultName, methodInfo.name(), MethodHelper.getPropertyName(Direction.IN, methodInfo.name()), name, reference);
        if (ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operation)) {
            argument.setSourceArgument(true);
        }
        this.fieldCreator.configure((Field)argument, argumentType, annotationsForThisArgument);
        return Optional.of(argument);
    }

    private static boolean isSourceAnnotationOnSourceOperation(Annotations annotationsForArgument, Operation operation) {
        return operation.isSourceField() && annotationsForArgument.containsOneOfTheseAnnotations(Annotations.SOURCE);
    }
}

