/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.schema.model.WrapperType;
import java.util.Optional;
import org.jboss.jandex.Type;

public class WrapperCreator {
    private WrapperCreator() {
    }

    public static Optional<Wrapper> createWrapper(Type type) {
        return WrapperCreator.createWrapper(null, type);
    }

    public static Optional<Wrapper> createWrapper(Type fieldType, Type methodType) {
        if (Classes.isWrapper(methodType)) {
            Optional<Wrapper> wrapperOfWrapper;
            Wrapper wrapper = new Wrapper(WrapperCreator.getWrapperType(methodType), methodType.name().toString());
            if (WrapperCreator.markParameterizedTypeNonNull(fieldType, methodType)) {
                wrapper.setNotEmpty(true);
            }
            if ((wrapperOfWrapper = WrapperCreator.getWrapperOfWrapper(methodType)).isPresent()) {
                wrapper.setWrapper(wrapperOfWrapper.get());
            }
            return Optional.of(wrapper);
        }
        return Optional.empty();
    }

    private static WrapperType getWrapperType(Type type) {
        if (Classes.isOptional(type)) {
            return WrapperType.OPTIONAL;
        }
        if (Classes.isArray(type)) {
            return WrapperType.ARRAY;
        }
        if (Classes.isCollection(type)) {
            return WrapperType.COLLECTION;
        }
        if (Classes.isParameterized(type)) {
            return WrapperType.UNKNOWN;
        }
        return null;
    }

    private static Optional<Wrapper> getWrapperOfWrapper(Type type) {
        if (Classes.isArray(type)) {
            Type typeInArray = type.asArrayType().component();
            return WrapperCreator.createWrapper(typeInArray);
        }
        if (Classes.isParameterized(type)) {
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            return WrapperCreator.createWrapper(typeInCollection);
        }
        return Optional.empty();
    }

    private static boolean markParameterizedTypeNonNull(Type fieldType, Type methodType) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        if (Classes.isWrapper(fieldType)) {
            Type typeInCollection = WrapperCreator.getTypeInCollection(fieldType);
            Type methodTypeInCollection = WrapperCreator.getTypeInCollection(methodType);
            Annotations annotationsInParameterizedType = Annotations.getAnnotationsForArray(typeInCollection, methodTypeInCollection);
            return NonNullHelper.markAsNonNull(typeInCollection, annotationsInParameterizedType, true);
        }
        return false;
    }

    private static Type getTypeInCollection(Type type) {
        if (Classes.isArray(type)) {
            Type typeInArray = type.asArrayType().component();
            return WrapperCreator.getTypeInCollection(typeInArray);
        }
        if (Classes.isParameterized(type)) {
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            return WrapperCreator.getTypeInCollection(typeInCollection);
        }
        return type;
    }
}

