/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.Field;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class DirectiveTypeCreator {
    private static final Logger LOG = Logger.getLogger((String)DirectiveTypeCreator.class.getName());
    private final ReferenceCreator referenceCreator;
    private final TypeAutoNameStrategy autoNameStrategy;
    private final FieldCreator fieldCreator;

    public DirectiveTypeCreator(ReferenceCreator referenceCreator, TypeAutoNameStrategy autoNameStrategy, FieldCreator fieldCreator) {
        this.referenceCreator = referenceCreator;
        this.autoNameStrategy = autoNameStrategy;
        this.fieldCreator = fieldCreator;
    }

    public DirectiveType create(ClassInfo classInfo) {
        LOG.debug((Object)("Creating directive from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        DirectiveType directiveType = new DirectiveType();
        directiveType.setClassName(classInfo.name().toString());
        directiveType.setName(this.toDirectiveName(classInfo, annotations));
        directiveType.setDescription((String)DescriptionHelper.getDescriptionForType(annotations).orElse(null));
        directiveType.setLocations(this.getLocations(classInfo.classAnnotation(Annotations.DIRECTIVE)));
        for (MethodInfo method : classInfo.methods()) {
            DirectiveArgument argument = new DirectiveArgument();
            argument.setReference(this.referenceCreator.createReferenceForOperationArgument(method.returnType(), null));
            argument.setName(method.name());
            Annotations annotationsForMethod = Annotations.getAnnotationsForInterfaceField(method);
            this.fieldCreator.configure((Field)argument, method.returnType(), annotationsForMethod);
            directiveType.addArgumentType(argument);
        }
        return directiveType;
    }

    private String toDirectiveName(ClassInfo classInfo, Annotations annotations) {
        String name = TypeNameHelper.getAnyTypeName((String)null, null, classInfo, annotations, this.autoNameStrategy);
        if (Character.isUpperCase(name.charAt(0))) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private Set<String> getLocations(AnnotationInstance directiveAnnotation) {
        return Stream.of(directiveAnnotation.value("on").asEnumArray()).collect(Collectors.toSet());
    }
}

