/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class InputTypeCreator
implements Creator<InputType> {
    private static final Logger LOG = Logger.getLogger((String)InputTypeCreator.class.getName());
    private final FieldCreator fieldCreator;
    private final TypeAutoNameStrategy autoNameStrategy;
    private final DotName RECORD = DotName.createSimple((String)"java.lang.Record");
    private static final String JAVA_DOT = "java.";

    public InputTypeCreator(FieldCreator fieldCreator, TypeAutoNameStrategy autoNameStrategy) {
        this.fieldCreator = fieldCreator;
        this.autoNameStrategy = autoNameStrategy;
    }

    @Override
    public InputType create(ClassInfo classInfo, Reference reference) {
        if (!this.hasUseableConstructor(classInfo)) {
            throw new IllegalArgumentException("Class " + classInfo.name().toString() + " is used as input, but does neither have a public default constructor nor a JsonbCreator method");
        }
        LOG.debug((Object)("Creating Input from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(reference, ReferenceType.INPUT, classInfo, annotations, this.autoNameStrategy);
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        InputType inputType = new InputType(classInfo.name().toString(), name, description);
        this.addFields(inputType, classInfo, reference);
        return inputType;
    }

    public boolean hasUseableConstructor(ClassInfo classInfo) {
        MethodInfo constructor = this.findCreator(classInfo);
        return constructor != null;
    }

    public MethodInfo findCreator(ClassInfo classInfo) {
        if (classInfo.superName().equals((Object)this.RECORD)) {
            for (MethodInfo constructor : classInfo.constructors()) {
                if (!Modifier.isPublic(constructor.flags())) continue;
                return constructor;
            }
            return null;
        }
        for (MethodInfo constructor : classInfo.constructors()) {
            if (!Modifier.isPublic(constructor.flags())) continue;
            if (constructor.parameters().isEmpty()) {
                return constructor;
            }
            if (!constructor.hasAnnotation(Annotations.JSONB_CREATOR) && !constructor.hasAnnotation(Annotations.JACKSON_CREATOR)) continue;
            return constructor;
        }
        for (MethodInfo factoryMethod : classInfo.methods()) {
            if (!Modifier.isStatic(factoryMethod.flags()) || !Modifier.isPublic(factoryMethod.flags()) || !factoryMethod.hasAnnotation(Annotations.JSONB_CREATOR) && !factoryMethod.hasAnnotation(Annotations.JACKSON_CREATOR)) continue;
            return factoryMethod;
        }
        return null;
    }

    private void addFields(InputType inputType, ClassInfo classInfo, Reference reference) {
        ArrayList allMethods = new ArrayList();
        HashMap<String, FieldInfo> allFields = new HashMap<String, FieldInfo>();
        MethodInfo creator = this.findCreator(classInfo);
        ClassInfo c = classInfo;
        while (c != null) {
            if (!c.toString().startsWith(JAVA_DOT)) {
                allMethods.addAll(c.methods());
                for (FieldInfo fieldInfo : c.fields()) {
                    allFields.putIfAbsent(fieldInfo.name(), fieldInfo);
                }
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (short i = 0; i < creator.parameters().size(); i = (short)(i + 1)) {
            FieldInfo fieldInfo;
            String fieldName = creator.parameterName((int)i);
            fieldInfo = (FieldInfo)allFields.remove(fieldName);
            Optional<Field> maybeField = this.fieldCreator.createFieldForParameter(creator, i, fieldInfo, reference);
            maybeField.ifPresent(arg_0 -> ((InputType)inputType).addField(arg_0));
            maybeField.ifPresent(arg_0 -> ((InputType)inputType).addCreatorParameter(arg_0));
        }
        for (MethodInfo methodInfo : allMethods) {
            if (!MethodHelper.isPropertyMethod(Direction.IN, methodInfo)) continue;
            String fieldName = MethodHelper.getPropertyName(Direction.IN, methodInfo.name());
            FieldInfo fieldInfo = (FieldInfo)allFields.remove(fieldName);
            this.fieldCreator.createFieldForPojo(Direction.IN, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((InputType)inputType).addField(arg_0));
        }
        if (!allFields.isEmpty()) {
            for (FieldInfo fieldInfo : allFields.values()) {
                this.fieldCreator.createFieldForPojo(Direction.IN, fieldInfo, reference).ifPresent(arg_0 -> ((InputType)inputType).addField(arg_0));
            }
        }
    }
}

