/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.WrapperCreator;
import io.smallrye.graphql.schema.helper.AdaptToHelper;
import io.smallrye.graphql.schema.helper.AdaptWithHelper;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.schema.model.Wrapper;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public abstract class ModelCreator {
    private Directives directives;
    protected final ReferenceCreator referenceCreator;

    public ModelCreator(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    public ReferenceCreator getReferenceCreator() {
        return this.referenceCreator;
    }

    public TypeAutoNameStrategy getTypeAutoNameStrategy() {
        return this.referenceCreator.getTypeAutoNameStrategy();
    }

    protected static Type getReturnType(MethodInfo methodInfo) {
        return methodInfo.returnType();
    }

    protected static Type getReturnType(FieldInfo fieldInfo) {
        return fieldInfo.type();
    }

    protected void populateField(Direction direction, Field field, Type type, Annotations annotations) {
        field.setWrapper((Wrapper)WrapperCreator.createWrapper(type).orElse(null));
        this.doPopulateField(direction, field, type, annotations);
    }

    protected void populateField(Direction direction, Field field, Type fieldType, Type methodType, Annotations annotations) {
        field.setWrapper((Wrapper)WrapperCreator.createWrapper(fieldType, methodType).orElse(null));
        this.doPopulateField(direction, field, methodType, annotations);
    }

    private void doPopulateField(Direction direction, Field field, Type type, Annotations annotations) {
        DescriptionHelper.getDescriptionForField(annotations, type).ifPresent(arg_0 -> ((Field)field).setDescription(arg_0));
        if (NonNullHelper.markAsNonNull(type, annotations)) {
            field.setNotNull(true);
        }
        field.setTransformation((Transformation)FormatHelper.getFormat(type, annotations).orElse(null));
        field.setAdaptTo((AdaptTo)AdaptToHelper.getAdaptTo(field, annotations).orElse(null));
        field.setAdaptWith((AdaptWith)AdaptWithHelper.getAdaptWith(direction, this.referenceCreator, field, annotations).orElse(null));
        field.setDefaultValue((String)DefaultValueHelper.getDefaultValue(annotations).orElse(null));
        if (this.directives != null) {
            field.setDirectiveInstances(this.directives.buildDirectiveInstances(name -> annotations.getOneOfTheseAnnotations((DotName)name).orElse(null)));
        }
    }
}

