/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.Map;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class TypeNameHelper {
    private static final Logger LOG = Logger.getLogger((String)TypeNameHelper.class.getName());
    private static final String INPUT = "Input";
    private static final String UNDERSCORE = "_";

    private TypeNameHelper() {
    }

    public static String getAnyTypeName(Reference reference, ReferenceType referenceType, ClassInfo classInfo, Annotations annotationsForThisClass, TypeAutoNameStrategy autoNameStrategy) {
        String parametrizedTypeNameExtension = TypeNameHelper.createParametrizedTypeNameExtension(reference);
        return TypeNameHelper.getAnyTypeName(parametrizedTypeNameExtension, referenceType, classInfo, annotationsForThisClass, autoNameStrategy);
    }

    public static String getAnyTypeName(String parametrizedTypeNameExtension, ReferenceType referenceType, ClassInfo classInfo, Annotations annotationsForThisClass, TypeAutoNameStrategy autoNameStrategy) {
        if (Classes.isEnum(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.ENUM, parametrizedTypeNameExtension, autoNameStrategy);
        }
        if (Classes.isInterface(classInfo)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INTERFACE, parametrizedTypeNameExtension, autoNameStrategy);
        }
        if (referenceType.equals((Object)ReferenceType.TYPE)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.TYPE, parametrizedTypeNameExtension, autoNameStrategy);
        }
        if (referenceType.equals((Object)ReferenceType.INPUT)) {
            return TypeNameHelper.getNameForClassType(classInfo, annotationsForThisClass, Annotations.INPUT, parametrizedTypeNameExtension, INPUT, autoNameStrategy);
        }
        if (referenceType.equals((Object)ReferenceType.SCALAR)) {
            return classInfo.name().withoutPackagePrefix();
        }
        LOG.warn((Object)("Using default name for " + classInfo.simpleName() + " [" + referenceType.name() + "]"));
        return classInfo.name().withoutPackagePrefix();
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName, String parametrizedTypeNameExtension, TypeAutoNameStrategy autoNameStrategy) {
        return TypeNameHelper.getNameForClassType(classInfo, annotations, typeName, parametrizedTypeNameExtension, null, autoNameStrategy);
    }

    private static String getNameForClassType(ClassInfo classInfo, Annotations annotations, DotName typeName, String parametrizedTypeNameExtension, String postFix, TypeAutoNameStrategy autoNameStrategy) {
        StringBuilder sb = new StringBuilder();
        if (annotations.containsKeyAndValidValue(typeName)) {
            AnnotationValue annotationValue = annotations.getAnnotationValue(typeName);
            sb.append(annotationValue.asString().trim());
            if (parametrizedTypeNameExtension != null) {
                sb.append(parametrizedTypeNameExtension);
            }
        } else if (annotations.containsKeyAndValidValue(Annotations.NAME)) {
            sb.append(annotations.getAnnotationValue(Annotations.NAME).asString().trim());
            if (parametrizedTypeNameExtension != null) {
                sb.append(parametrizedTypeNameExtension);
            }
        } else {
            sb.append(TypeNameHelper.applyNamingStrategy(classInfo, autoNameStrategy));
            if (parametrizedTypeNameExtension != null) {
                sb.append(parametrizedTypeNameExtension);
            }
            if (postFix != null) {
                sb.append(postFix);
            }
        }
        return sb.toString();
    }

    public static String createParametrizedTypeNameExtension(Map<String, Reference> parametrizedTypeArgumentsReferences) {
        if (parametrizedTypeArgumentsReferences == null || parametrizedTypeArgumentsReferences.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Reference gp : parametrizedTypeArgumentsReferences.values()) {
            TypeNameHelper.appendParametrizedArgumet(sb, gp);
        }
        return sb.toString();
    }

    private static final void appendParametrizedArgumet(StringBuilder sb, Reference gp) {
        sb.append(UNDERSCORE);
        sb.append(gp.getName());
    }

    public static String createParametrizedTypeNameExtension(Reference reference) {
        if (!reference.isAddParametrizedTypeNameExtension() || reference.getParametrizedTypeArguments() == null || reference.getParametrizedTypeArguments().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Reference gp : reference.getParametrizedTypeArguments().values()) {
            sb.append(UNDERSCORE);
            sb.append(gp.getName());
        }
        return sb.toString();
    }

    private static String applyNamingStrategy(ClassInfo classInfo, TypeAutoNameStrategy autoNameStrategy) {
        DotName enclosingClass;
        if (autoNameStrategy.equals((Object)TypeAutoNameStrategy.Full)) {
            return classInfo.name().toString().replaceAll("\\.", UNDERSCORE).replaceAll("\\$", "");
        }
        if (autoNameStrategy.equals((Object)TypeAutoNameStrategy.MergeInnerClass) && (enclosingClass = classInfo.enclosingClass()) != null) {
            return enclosingClass.local() + classInfo.name().local();
        }
        return classInfo.name().local();
    }
}

