/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.SourceOperationHelper;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.logging.Logger;

abstract class AbstractCreator
implements Creator<Type> {
    private static final Logger LOG = Logger.getLogger((String)AbstractCreator.class.getName());
    private final OperationCreator operationCreator;
    private final ReferenceCreator referenceCreator;
    private Directives directives;

    protected AbstractCreator(OperationCreator operationCreator, ReferenceCreator referenceCreator) {
        this.operationCreator = operationCreator;
        this.referenceCreator = referenceCreator;
    }

    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    protected abstract ReferenceType referenceType();

    @Override
    public Type create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(classInfo, annotations, this.referenceCreator.getTypeAutoNameStrategy(), this.referenceType(), reference.getClassParametrizedTypes());
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        Type type = new Type(classInfo.name().toString(), name, description);
        type.setIsInterface(this.referenceType() == ReferenceType.INTERFACE);
        this.addFields(type, classInfo, reference);
        this.addInterfaces(type, classInfo, reference);
        this.addOperations(type, classInfo);
        this.addDirectives(type, classInfo);
        return type;
    }

    protected abstract void addFields(Type var1, ClassInfo var2, Reference var3);

    private void addDirectives(Type type, ClassInfo classInfo) {
        type.setDirectiveInstances(this.directives.buildDirectiveInstances(arg_0 -> ((ClassInfo)classInfo).classAnnotation(arg_0)));
    }

    private void addInterfaces(Type type, ClassInfo classInfo, Reference reference) {
        List interfaceNames = classInfo.interfaceTypes();
        for (org.jboss.jandex.Type interfaceType : interfaceNames) {
            ClassInfo interfaceInfo;
            if (!InterfaceCreator.canAddInterfaceIntoScheme(interfaceType.name().toString()) || (interfaceInfo = ScanningContext.getIndex().getClassByName(interfaceType.name())) == null) continue;
            Annotations annotationsForInterface = Annotations.getAnnotationsForClass(interfaceInfo);
            Reference interfaceRef = this.referenceCreator.createReferenceForInterfaceField(interfaceType, annotationsForInterface, reference);
            type.addInterface(interfaceRef);
            this.addInterfaces(type, interfaceInfo, reference);
        }
    }

    protected void addOperations(Type type, ClassInfo classInfo) {
        SourceOperationHelper sourceOperationHelper = new SourceOperationHelper();
        Map<DotName, List<MethodParameterInfo>> sourceFields = sourceOperationHelper.getSourceAnnotations();
        Map<DotName, List<MethodParameterInfo>> batchedFields = sourceOperationHelper.getSourceListAnnotations();
        type.setOperations(this.toOperations(sourceFields, type, classInfo));
        type.setBatchOperations(this.toOperations(batchedFields, type, classInfo));
    }

    protected Map<String, Operation> toOperations(Map<DotName, List<MethodParameterInfo>> sourceFields, Type type, ClassInfo classInfo) {
        HashMap<String, Operation> operations = new HashMap<String, Operation>();
        if (sourceFields.containsKey(classInfo.name())) {
            List<MethodParameterInfo> methodParameterInfos = sourceFields.get(classInfo.name());
            for (MethodParameterInfo methodParameterInfo : methodParameterInfos) {
                MethodInfo methodInfo = methodParameterInfo.method();
                Operation o = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, type);
                operations.put(o.getName(), o);
            }
        }
        for (Reference anInterface : type.getInterfaces()) {
            String className = anInterface.getClassName();
            if (!sourceFields.containsKey(DotName.createSimple((String)className))) continue;
            List<MethodParameterInfo> methodParameterInfos = sourceFields.get(DotName.createSimple((String)className));
            for (MethodParameterInfo methodParameterInfo : methodParameterInfos) {
                MethodInfo methodInfo = methodParameterInfo.method();
                Operation o = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, type);
                operations.put(o.getName(), o);
            }
        }
        return operations;
    }
}

