/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Scalars;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class BeanValidationDirectivesHelper {
    private static final DotName VALIDATION_ANNOTATION_EMAIL = DotName.createSimple((String)"javax.validation.constraints.Email");
    private static final DotName VALIDATION_ANNOTATION_MAX = DotName.createSimple((String)"javax.validation.constraints.Max");
    private static final DotName VALIDATION_ANNOTATION_MIN = DotName.createSimple((String)"javax.validation.constraints.Min");
    private static final DotName VALIDATION_ANNOTATION_DECIMAL_MIN = DotName.createSimple((String)"javax.validation.constraints.DecimalMin");
    private static final DotName VALIDATION_ANNOTATION_DECIMAL_MAX = DotName.createSimple((String)"javax.validation.constraints.DecimalMax");
    private static final DotName VALIDATION_ANNOTATION_PATTERN = DotName.createSimple((String)"javax.validation.constraints.Pattern");
    private static final DotName VALIDATION_ANNOTATION_SIZE = DotName.createSimple((String)"javax.validation.constraints.Size");
    public static final DirectiveType CONSTRAINT_DIRECTIVE_TYPE;
    private static Logger LOGGER;

    private static void addArgument(String name, Reference reference) {
        DirectiveArgument arg = new DirectiveArgument();
        arg.setName(name);
        arg.setReference(reference);
        CONSTRAINT_DIRECTIVE_TYPE.addArgumentType(arg);
    }

    public List<DirectiveInstance> transformBeanValidationConstraintsToDirectives(Annotations annotations) {
        ArrayList<DirectiveInstance> result = new ArrayList<DirectiveInstance>();
        Set<DotName> annotationNames = annotations.getAnnotationNames();
        for (DotName annotationName : annotationNames) {
            String value;
            DirectiveInstance directive;
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_SIZE)) {
                Integer max;
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                Integer min = this.getIntValue(annotations, annotationName, "min");
                if (min != null) {
                    directive.setValue("minLength", (Object)min);
                }
                if ((max = this.getIntValue(annotations, annotationName, "max")) != null) {
                    directive.setValue("maxLength", (Object)max);
                }
                result.add(directive);
            }
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_EMAIL)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("format", (Object)"email");
                result.add(directive);
            }
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_MAX)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("max", (Object)this.getLongValue(annotations, annotationName, "value"));
                result.add(directive);
            }
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_MIN)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("min", (Object)this.getLongValue(annotations, annotationName, "value"));
                result.add(directive);
            }
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_DECIMAL_MAX)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                value = this.getStringValue(annotations, annotationName, "value");
                try {
                    directive.setValue("maxFloat", (Object)new BigDecimal(value).doubleValue());
                    result.add(directive);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn((Object)("Not generating a bean validation directive for " + annotations.getAnnotationValue(annotationName) + " because the value can't be parsed as a BigDecimal"));
                }
            }
            if (annotationName.equals((Object)VALIDATION_ANNOTATION_DECIMAL_MIN)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                value = this.getStringValue(annotations, annotationName, "value");
                try {
                    directive.setValue("minFloat", (Object)new BigDecimal(value).doubleValue());
                    result.add(directive);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn((Object)("Not generating a bean validation directive for " + annotations.getAnnotationValue(annotationName) + " because the value can't be parsed as a BigDecimal"));
                }
            }
            if (!annotationName.equals((Object)VALIDATION_ANNOTATION_PATTERN)) continue;
            directive = new DirectiveInstance();
            directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
            directive.setValue("pattern", (Object)this.getStringValue(annotations, annotationName, "regexp"));
            result.add(directive);
        }
        return result;
    }

    private String getStringValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? aValue.asString() : null;
    }

    private Integer getIntValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? Integer.valueOf(aValue.asInt()) : null;
    }

    private Long getLongValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? Long.valueOf(aValue.asLong()) : null;
    }

    static {
        LOGGER = Logger.getLogger(BeanValidationDirectivesHelper.class);
        CONSTRAINT_DIRECTIVE_TYPE = new DirectiveType();
        CONSTRAINT_DIRECTIVE_TYPE.setName("constraint");
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        locations.add("INPUT_FIELD_DEFINITION");
        locations.add("ARGUMENT_DEFINITION");
        CONSTRAINT_DIRECTIVE_TYPE.setLocations(locations);
        CONSTRAINT_DIRECTIVE_TYPE.setDescription("Indicates a Bean Validation constraint");
        CONSTRAINT_DIRECTIVE_TYPE.setRepeatable(true);
        BeanValidationDirectivesHelper.addArgument("minLength", Scalars.getIntScalar());
        BeanValidationDirectivesHelper.addArgument("maxLength", Scalars.getIntScalar());
        BeanValidationDirectivesHelper.addArgument("format", Scalars.getStringScalar());
        BeanValidationDirectivesHelper.addArgument("min", Scalars.getBigIntegerScalar());
        BeanValidationDirectivesHelper.addArgument("minFloat", Scalars.getBigDecimalScalar());
        BeanValidationDirectivesHelper.addArgument("max", Scalars.getBigIntegerScalar());
        BeanValidationDirectivesHelper.addArgument("maxFloat", Scalars.getBigDecimalScalar());
        BeanValidationDirectivesHelper.addArgument("pattern", Scalars.getStringScalar());
    }
}

