/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.helper.Direction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class Annotations {
    private final Map<DotName, AnnotationInstance> annotationsMap;
    public final Map<DotName, AnnotationInstance> parentAnnotations;
    private static final short ZERO = 0;
    public static final DotName BLOCKING = DotName.createSimple((String)"io.smallrye.common.annotation.Blocking");
    public static final DotName NON_BLOCKING = DotName.createSimple((String)"io.smallrye.common.annotation.NonBlocking");
    public static final DotName TO_SCALAR = DotName.createSimple((String)"io.smallrye.graphql.api.ToScalar");
    public static final DotName ADAPT_TO_SCALAR = DotName.createSimple((String)"io.smallrye.graphql.api.AdaptToScalar");
    public static final DotName ADAPT_WITH = DotName.createSimple((String)"io.smallrye.graphql.api.AdaptWith");
    public static final DotName ERROR_CODE = DotName.createSimple((String)"io.smallrye.graphql.api.ErrorCode");
    public static final DotName DATAFETCHER = DotName.createSimple((String)"io.smallrye.graphql.api.DataFetcher");
    public static final DotName SUBCRIPTION = DotName.createSimple((String)"io.smallrye.graphql.api.Subscription");
    public static final DotName DIRECTIVE = DotName.createSimple((String)"io.smallrye.graphql.api.Directive");
    public static final DotName DEFAULT_NON_NULL = DotName.createSimple((String)"io.smallrye.graphql.api.DefaultNonNull");
    public static final DotName NULLABLE = DotName.createSimple((String)"io.smallrye.graphql.api.Nullable");
    public static final DotName GRAPHQL_API = DotName.createSimple((String)"org.eclipse.microprofile.graphql.GraphQLApi");
    public static final DotName QUERY = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Query");
    public static final DotName MUTATION = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Mutation");
    public static final DotName INPUT = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Input");
    public static final DotName TYPE = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Type");
    public static final DotName INTERFACE = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Interface");
    public static final DotName UNION = DotName.createSimple((String)"io.smallrye.graphql.api.Union");
    public static final DotName ENUM = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Enum");
    public static final DotName ID = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Id");
    public static final DotName DESCRIPTION = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Description");
    public static final DotName DATE_FORMAT = DotName.createSimple((String)"org.eclipse.microprofile.graphql.DateFormat");
    public static final DotName NUMBER_FORMAT = DotName.createSimple((String)"org.eclipse.microprofile.graphql.NumberFormat");
    public static final DotName DEFAULT_VALUE = DotName.createSimple((String)"org.eclipse.microprofile.graphql.DefaultValue");
    public static final DotName IGNORE = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Ignore");
    public static final DotName NON_NULL = DotName.createSimple((String)"org.eclipse.microprofile.graphql.NonNull");
    public static final DotName NAME = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Name");
    public static final DotName SOURCE = DotName.createSimple((String)"org.eclipse.microprofile.graphql.Source");
    public static final String JAVAX_JSONB = "javax.json.bind.annotation.";
    public static final DotName JAVAX_JSONB_DATE_FORMAT = DotName.createSimple((String)"javax.json.bind.annotation.JsonbDateFormat");
    public static final DotName JAVAX_JSONB_NUMBER_FORMAT = DotName.createSimple((String)"javax.json.bind.annotation.JsonbNumberFormat");
    public static final DotName JAVAX_JSONB_PROPERTY = DotName.createSimple((String)"javax.json.bind.annotation.JsonbProperty");
    public static final DotName JAVAX_JSONB_TRANSIENT = DotName.createSimple((String)"javax.json.bind.annotation.JsonbTransient");
    public static final DotName JAVAX_JSONB_CREATOR = DotName.createSimple((String)"javax.json.bind.annotation.JsonbCreator");
    public static final DotName JAVAX_JSONB_TYPE_ADAPTER = DotName.createSimple((String)"javax.json.bind.annotation.JsonbTypeAdapter");
    public static final String JAKARTA_JSONB = "jakarta.json.bind.annotation.";
    public static final DotName JAKARTA_JSONB_DATE_FORMAT = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbDateFormat");
    public static final DotName JAKARTA_JSONB_NUMBER_FORMAT = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbNumberFormat");
    public static final DotName JAKARTA_JSONB_PROPERTY = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbProperty");
    public static final DotName JAKARTA_JSONB_TRANSIENT = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbTransient");
    public static final DotName JAKARTA_JSONB_CREATOR = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbCreator");
    public static final DotName JAKARTA_JSONB_TYPE_ADAPTER = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbTypeAdapter");
    public static final DotName JACKSON_IGNORE = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonIgnore");
    public static final DotName JACKSON_PROPERTY = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonProperty");
    public static final DotName JACKSON_CREATOR = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonCreator");
    public static final DotName JACKSON_FORMAT = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonFormat");
    public static final DotName JAVAX_BEAN_VALIDATION_NOT_NULL = DotName.createSimple((String)"javax.validation.constraints.NotNull");
    public static final DotName JAVAX_BEAN_VALIDATION_NOT_EMPTY = DotName.createSimple((String)"javax.validation.constraints.NotEmpty");
    public static final DotName JAVAX_BEAN_VALIDATION_NOT_BLANK = DotName.createSimple((String)"javax.validation.constraints.NotBlank");
    public static final DotName JAKARTA_BEAN_VALIDATION_NOT_NULL = DotName.createSimple((String)"jakarta.validation.constraints.NotNull");
    public static final DotName JAKARTA_BEAN_VALIDATION_NOT_EMPTY = DotName.createSimple((String)"jakarta.validation.constraints.NotEmpty");
    public static final DotName JAKARTA_BEAN_VALIDATION_NOT_BLANK = DotName.createSimple((String)"jakarta.validation.constraints.NotBlank");
    public static final DotName KOTLIN_NOT_NULL = DotName.createSimple((String)"org.jetbrains.annotations.NotNull");

    public static Annotations getAnnotationsForMethod(MethodInfo methodInfo) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : methodInfo.annotations()) {
            DotName name = annotationInstance.name();
            AnnotationTarget.Kind kind = annotationInstance.target().kind();
            if (!kind.equals((Object)AnnotationTarget.Kind.METHOD)) continue;
            annotationMap.put(name, annotationInstance);
        }
        Type type = methodInfo.returnType();
        if (Classes.isParameterized(type)) {
            Type wrappedType = (Type)type.asParameterizedType().arguments().get(0);
            for (AnnotationInstance annotationInstance : wrappedType.annotations()) {
                DotName name = annotationInstance.name();
                annotationMap.put(name, annotationInstance);
            }
        }
        Map<DotName, AnnotationInstance> parentAnnotations = Annotations.getParentAnnotations(methodInfo.declaringClass());
        return new Annotations(annotationMap, parentAnnotations);
    }

    private static Map<DotName, AnnotationInstance> getParentAnnotations(FieldInfo fieldInfo, MethodInfo methodInfo) {
        ClassInfo declaringClass = fieldInfo != null ? fieldInfo.declaringClass() : methodInfo.declaringClass();
        return Annotations.getParentAnnotations(declaringClass);
    }

    private static Map<DotName, AnnotationInstance> getParentAnnotations(ClassInfo classInfo) {
        HashMap<DotName, AnnotationInstance> parentAnnotations = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
            parentAnnotations.putIfAbsent(classAnnotation.name(), classAnnotation);
        }
        Map<DotName, AnnotationInstance> packageAnnotations = Annotations.getPackageAnnotations(classInfo);
        for (DotName dotName : packageAnnotations.keySet()) {
            parentAnnotations.putIfAbsent(dotName, packageAnnotations.get(dotName));
        }
        return parentAnnotations;
    }

    private static Map<DotName, AnnotationInstance> getPackageAnnotations(ClassInfo classInfo) {
        ClassInfo packageInfo;
        HashMap<DotName, AnnotationInstance> packageAnnotations = new HashMap<DotName, AnnotationInstance>();
        DotName packageName = Annotations.packageInfo(classInfo);
        if (packageName != null && (packageInfo = ScanningContext.getIndex().getClassByName(packageName)) != null) {
            for (AnnotationInstance packageAnnotation : packageInfo.classAnnotations()) {
                packageAnnotations.putIfAbsent(packageAnnotation.name(), packageAnnotation);
            }
        }
        return packageAnnotations;
    }

    private static DotName packageInfo(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return DotName.createSimple((String)(className.substring(0, index) + ".package-info"));
    }

    public static Annotations getAnnotationsForInterfaceField(MethodInfo methodInfo) {
        return Annotations.getAnnotationsForOutputField(null, methodInfo);
    }

    public static Annotations getAnnotationsForPojo(Direction direction, FieldInfo fieldInfo) {
        return Annotations.getAnnotationsForPojo(direction, fieldInfo, null);
    }

    public static Annotations getAnnotationsForPojo(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo) {
        if (direction.equals((Object)Direction.IN)) {
            return Annotations.getAnnotationsForInputField(fieldInfo, methodInfo);
        }
        return Annotations.getAnnotationsForOutputField(fieldInfo, methodInfo);
    }

    public static Annotations getAnnotationsForInputCreator(MethodInfo method, short position, FieldInfo fieldInfo) {
        Map<DotName, AnnotationInstance> annotationsForField = Annotations.getAnnotationsForField(fieldInfo, null);
        if (fieldInfo != null) {
            annotationsForField.putAll(Annotations.getTypeUseAnnotations(fieldInfo.type()));
        }
        annotationsForField.putAll(Annotations.getAnnotationsForArgument((MethodInfo)method, (short)position).annotationsMap);
        Map<DotName, AnnotationInstance> parentAnnotations = Annotations.getParentAnnotations(fieldInfo, method);
        return new Annotations(annotationsForField, parentAnnotations);
    }

    public static Annotations getAnnotationsForClass(ClassInfo classInfo) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : classInfo.classAnnotations()) {
            DotName name = annotationInstance.name();
            annotationMap.put(name, annotationInstance);
        }
        Map<DotName, AnnotationInstance> packageAnnotations = Annotations.getPackageAnnotations(classInfo);
        for (DotName dotName : packageAnnotations.keySet()) {
            annotationMap.putIfAbsent(dotName, packageAnnotations.get(dotName));
        }
        return new Annotations(annotationMap, packageAnnotations);
    }

    public static Annotations getAnnotationsForArray(Type typeInCollection, Type methodTypeInCollection) {
        Map<DotName, AnnotationInstance> annotationMap = Annotations.getAnnotationsForType(typeInCollection);
        annotationMap.putAll(Annotations.getAnnotationsForType(methodTypeInCollection));
        return new Annotations(annotationMap);
    }

    public static Annotations getAnnotationsForArgument(MethodInfo methodInfo, short pos) {
        if (pos >= methodInfo.parametersCount()) {
            throw new IndexOutOfBoundsException("Parameter at position " + pos + " not found on method " + methodInfo.name());
        }
        Type parameterType = methodInfo.parameterType((int)pos);
        Map<DotName, AnnotationInstance> annotationMap = Annotations.getAnnotations(parameterType);
        for (AnnotationInstance anno : methodInfo.annotations()) {
            MethodParameterInfo methodParameter;
            short position;
            if (!anno.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) || (position = (methodParameter = anno.target().asMethodParameter()).position()) != pos) continue;
            annotationMap.put(anno.name(), anno);
        }
        Map<DotName, AnnotationInstance> parentAnnotations = Annotations.getParentAnnotations(methodInfo.declaringClass());
        return new Annotations(annotationMap, parentAnnotations);
    }

    public static boolean isJsonBAnnotation(AnnotationInstance instance) {
        return instance.name().toString().startsWith(JAKARTA_JSONB) || instance.name().toString().startsWith(JAVAX_JSONB);
    }

    private Annotations(Map<DotName, AnnotationInstance> annotations) {
        this(annotations, new HashMap<DotName, AnnotationInstance>());
    }

    private Annotations(Map<DotName, AnnotationInstance> annotations, Map<DotName, AnnotationInstance> parentAnnotations) {
        this.annotationsMap = annotations;
        this.parentAnnotations = parentAnnotations;
    }

    public Set<DotName> getAnnotationNames() {
        return this.annotationsMap.keySet();
    }

    public Annotations removeAnnotations(DotName ... annotations) {
        HashMap<DotName, AnnotationInstance> newAnnotationsMap = new HashMap<DotName, AnnotationInstance>(this.annotationsMap);
        for (DotName annotation : annotations) {
            newAnnotationsMap.remove(annotation);
        }
        return new Annotations(newAnnotationsMap, this.parentAnnotations);
    }

    public AnnotationValue getAnnotationValue(DotName annotation) {
        return this.annotationsMap.get(annotation).value();
    }

    public AnnotationValue getAnnotationValue(DotName annotation, String name) {
        return this.annotationsMap.get(annotation).value(name);
    }

    public boolean containsKeyAndValidValue(DotName annotation) {
        return this.annotationsMap.containsKey(annotation) && this.annotationsMap.get(annotation).value() != null;
    }

    public boolean containsOneOfTheseAnnotations(DotName ... annotations) {
        for (DotName name : annotations) {
            if (!this.annotationsMap.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOneOfTheseInheritableAnnotations(DotName ... annotations) {
        for (DotName name : annotations) {
            if (!this.parentAnnotations.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Optional<AnnotationInstance> getOneOfTheseAnnotations(DotName ... annotations) {
        for (DotName name : annotations) {
            if (!this.annotationsMap.containsKey(name)) continue;
            return Optional.of(this.annotationsMap.get(name));
        }
        return Optional.empty();
    }

    public Optional<String> getOneOfTheseAnnotationsValue(DotName ... annotations) {
        for (DotName dotName : annotations) {
            if (dotName == null || !this.containsKeyAndValidValue(dotName)) continue;
            return this.getStringValue(dotName);
        }
        return Optional.empty();
    }

    public Optional<String> getOneOfTheseMethodAnnotationsValue(DotName ... annotations) {
        for (DotName dotName : annotations) {
            if (dotName == null || !this.hasValidMethodAnnotation(dotName)) continue;
            return this.getStringValue(dotName);
        }
        return Optional.empty();
    }

    public Optional<String> getOneOfTheseMethodParameterAnnotationsValue(DotName ... annotations) {
        for (DotName dotName : annotations) {
            if (dotName == null || !this.hasValidMethodParameterAnnotation(dotName)) continue;
            return this.getStringValue(dotName);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.annotationsMap.toString();
    }

    private boolean hasValidMethodAnnotation(DotName annotation) {
        return this.containsKeyAndValidValue(annotation) && Annotations.isMethodAnnotation(this.getAnnotation(annotation));
    }

    private boolean hasValidMethodParameterAnnotation(DotName annotation) {
        return this.containsKeyAndValidValue(annotation) && Annotations.isMethodParameterAnnotation(this.getAnnotation(annotation));
    }

    private AnnotationInstance getAnnotation(DotName key) {
        return this.annotationsMap.get(key);
    }

    private Optional<String> getStringValue(DotName annotation) {
        AnnotationInstance annotationInstance = this.getAnnotation(annotation);
        if (annotationInstance != null) {
            return this.getStringValue(annotationInstance);
        }
        return Optional.empty();
    }

    private Optional<String> getStringValue(AnnotationInstance annotationInstance) {
        AnnotationValue value = annotationInstance.value();
        if (value != null) {
            return this.getStringValue(value);
        }
        return Optional.empty();
    }

    private Optional<String> getStringValue(AnnotationValue annotationValue) {
        String value;
        if (annotationValue != null && (value = annotationValue.asString()) != null && !value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean isMethodAnnotation(AnnotationInstance instance) {
        return instance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD);
    }

    private static boolean isMethodParameterAnnotation(AnnotationInstance instance) {
        return instance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER);
    }

    private static Annotations getAnnotationsForInputField(FieldInfo fieldInfo, MethodInfo methodInfo) {
        List parameters;
        Map<DotName, AnnotationInstance> annotationsForField = Annotations.getAnnotationsForField(fieldInfo, methodInfo);
        if (fieldInfo != null) {
            annotationsForField.putAll(Annotations.getTypeUseAnnotations(fieldInfo.type()));
        }
        if (methodInfo != null && !(parameters = methodInfo.parameterTypes()).isEmpty()) {
            Type param = (Type)parameters.get(0);
            annotationsForField.putAll(Annotations.getTypeUseAnnotations(param));
        }
        Map<DotName, AnnotationInstance> parentAnnotations = Annotations.getParentAnnotations(fieldInfo, methodInfo);
        return new Annotations(annotationsForField, parentAnnotations);
    }

    private static Annotations getAnnotationsForOutputField(FieldInfo fieldInfo, MethodInfo methodInfo) {
        Type returnType;
        Map<DotName, AnnotationInstance> annotationsForField = Annotations.getAnnotationsForField(fieldInfo, methodInfo);
        if (fieldInfo != null) {
            annotationsForField.putAll(Annotations.getTypeUseAnnotations(fieldInfo.type()));
        }
        if (methodInfo != null && (returnType = methodInfo.returnType()) != null) {
            annotationsForField.putAll(Annotations.getTypeUseAnnotations(methodInfo.returnType()));
        }
        Map<DotName, AnnotationInstance> parentAnnotations = Annotations.getParentAnnotations(fieldInfo, methodInfo);
        return new Annotations(annotationsForField, parentAnnotations);
    }

    private static Map<DotName, AnnotationInstance> getTypeUseAnnotations(Type type) {
        if (type != null) {
            return Annotations.getAnnotationsWithFilter(type, DATE_FORMAT, NUMBER_FORMAT);
        }
        return Collections.emptyMap();
    }

    private static Map<DotName, AnnotationInstance> getAnnotations(Type type) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        if (type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            annotationMap.putAll(Annotations.getAnnotations(typeInCollection));
        } else {
            List annotations = type.annotations();
            for (AnnotationInstance annotationInstance : annotations) {
                annotationMap.put(annotationInstance.name(), annotationInstance);
            }
        }
        return annotationMap;
    }

    private static Map<DotName, AnnotationInstance> getAnnotationsForType(Type type) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : type.annotations()) {
            DotName name = annotationInstance.name();
            annotationMap.put(name, annotationInstance);
        }
        return annotationMap;
    }

    private static Map<DotName, AnnotationInstance> getAnnotationsForField(FieldInfo fieldInfo, MethodInfo methodInfo) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        if (fieldInfo != null) {
            annotationMap.putAll(Annotations.listToMap(fieldInfo.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.FIELD).collect(Collectors.toList())));
        }
        if (methodInfo != null) {
            annotationMap.putAll(Annotations.listToMap(methodInfo.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD || ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.toList())));
        }
        return annotationMap;
    }

    private static Map<DotName, AnnotationInstance> listToMap(List<AnnotationInstance> annotationInstances) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : annotationInstances) {
            DotName name = annotationInstance.name();
            annotationMap.put(name, annotationInstance);
        }
        return annotationMap;
    }

    private static Map<DotName, AnnotationInstance> getAnnotationsWithFilter(Type type, DotName ... filter) {
        HashMap<DotName, AnnotationInstance> annotationMap = new HashMap<DotName, AnnotationInstance>();
        if (type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
            annotationMap.putAll(Annotations.getAnnotationsWithFilter(typeInCollection, filter));
        } else {
            List annotations = type.annotations();
            for (AnnotationInstance annotationInstance : annotations) {
                if (!Arrays.asList(filter).contains(annotationInstance.name())) continue;
                annotationMap.put(annotationInstance.name(), annotationInstance);
            }
        }
        return annotationMap;
    }
}

