/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ModelCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.BeanValidationDirectivesHelper;
import io.smallrye.graphql.schema.helper.DeprecatedDirectivesHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ArgumentCreator
extends ModelCreator {
    private final BeanValidationDirectivesHelper validationHelper;
    private final DeprecatedDirectivesHelper deprecatedHelper;
    private final Logger logger = Logger.getLogger((String)ArgumentCreator.class.getName());
    private static final DotName CONTEXT = DotName.createSimple((String)"io.smallrye.graphql.api.Context");
    private static final Reference CONTEXT_REF = new Reference.Builder().className(CONTEXT.toString()).name(CONTEXT.toString()).type(ReferenceType.TYPE).build();

    public ArgumentCreator(ReferenceCreator referenceCreator) {
        super(referenceCreator);
        this.validationHelper = new BeanValidationDirectivesHelper();
        this.deprecatedHelper = new DeprecatedDirectivesHelper();
    }

    @Override
    public String getDirectiveLocation() {
        return "ARGUMENT_DEFINITION";
    }

    public Optional<Argument> createArgument(Operation operation, MethodInfo methodInfo, short position) {
        List<DirectiveInstance> constraintDirectives;
        if (position >= methodInfo.parametersCount()) {
            throw new SchemaBuilderException("Can not create argument for parameter [" + position + "] on method [" + String.valueOf(methodInfo.declaringClass().name()) + "#" + methodInfo.name() + "]: method has only " + methodInfo.parametersCount() + " parameters");
        }
        Annotations annotationsForThisArgument = Annotations.getAnnotationsForArgument(methodInfo, position);
        if (IgnoreHelper.shouldIgnore(annotationsForThisArgument)) {
            return Optional.empty();
        }
        Type argumentType = methodInfo.parameterType((int)position);
        String defaultName = methodInfo.parameterName((int)position);
        String name = annotationsForThisArgument.getOneOfTheseAnnotationsValue(Annotations.NAME).orElse(defaultName);
        Reference reference = ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operation) ? this.referenceCreator.createReferenceForSourceArgument(argumentType, annotationsForThisArgument) : (!argumentType.name().equals((Object)CONTEXT) ? this.referenceCreator.createReferenceForOperationArgument(argumentType, annotationsForThisArgument) : CONTEXT_REF);
        Argument argument = new Argument(defaultName, methodInfo.name(), MethodHelper.getPropertyName(Direction.IN, methodInfo.name()), name, reference);
        if (ArgumentCreator.isSourceAnnotationOnSourceOperation(annotationsForThisArgument, operation)) {
            argument.setSourceArgument(true);
        }
        if (this.validationHelper != null && !(constraintDirectives = this.validationHelper.transformBeanValidationConstraintsToDirectives(annotationsForThisArgument)).isEmpty()) {
            this.logger.debug((Object)("Adding constraint directives " + String.valueOf(constraintDirectives) + " to argument '" + argument.getName() + "' of method '" + argument.getMethodName() + "'"));
            argument.addDirectiveInstances(constraintDirectives);
        }
        if (this.deprecatedHelper != null && this.directives != null) {
            this.deprecatedHelper.transformDeprecatedToDirective(annotationsForThisArgument, this.directives.getDirectiveTypes().get(DotName.createSimple((String)"io.smallrye.graphql.api.Deprecated"))).ifPresent(deprecatedDirective -> {
                this.logger.debug((Object)("Adding deprecated directive " + String.valueOf(deprecatedDirective) + " to argument '" + argument.getName() + "' of method '" + argument.getMethodName() + "'"));
                argument.addDirectiveInstance(deprecatedDirective);
            });
        }
        this.populateField(Direction.IN, (Field)argument, argumentType, annotationsForThisArgument);
        return Optional.of(argument);
    }

    private static boolean isSourceAnnotationOnSourceOperation(Annotations annotationsForArgument, Operation operation) {
        return operation.isSourceField() && annotationsForArgument.containsOneOfTheseAnnotations(Annotations.SOURCE);
    }
}

