/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DeprecatedDirectivesHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.EnumValue;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class EnumCreator
implements Creator<EnumType> {
    private static final Logger LOG = Logger.getLogger((String)EnumCreator.class.getName());
    private final TypeAutoNameStrategy autoNameStrategy;
    private Directives directives;
    private final DeprecatedDirectivesHelper deprecatedHelper;

    public EnumCreator(TypeAutoNameStrategy autoNameStrategy) {
        this.autoNameStrategy = autoNameStrategy;
        this.deprecatedHelper = new DeprecatedDirectivesHelper();
    }

    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    @Override
    public EnumType create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating enum from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(classInfo, annotations, this.autoNameStrategy, ReferenceType.ENUM, reference.getAllParametrizedTypes());
        Optional<String> maybeDescription = DescriptionHelper.getDescriptionForType(annotations);
        EnumType enumType = new EnumType(classInfo.name().toString(), name, (String)maybeDescription.orElse(null));
        enumType.setDirectiveInstances(this.getDirectiveInstances(annotations, enumType.getClassName(), false));
        List fields = classInfo.fields();
        for (FieldInfo field : fields) {
            if (!classInfo.name().equals((Object)field.type().name())) continue;
            Annotations annotationsForField = Annotations.getAnnotationsForPojo(Direction.OUT, field);
            if (field.type().kind().equals((Object)Type.Kind.ARRAY) || IgnoreHelper.shouldIgnore(annotationsForField, field)) continue;
            String description = annotationsForField.getOneOfTheseAnnotationsValue(Annotations.DESCRIPTION).orElse(null);
            EnumValue enumValue = new EnumValue(description, field.name(), this.getDirectiveInstances(annotationsForField, field.name(), true));
            this.addDirectiveForDeprecated(annotationsForField, enumValue);
            enumType.addValue(enumValue);
        }
        return enumType;
    }

    @Override
    public String getDirectiveLocation() {
        return "ENUM";
    }

    private List<DirectiveInstance> getDirectiveInstances(Annotations annotations, String referenceName, boolean enumValue) {
        return this.directives.buildDirectiveInstances(annotations, enumValue ? "ENUM_VALUE" : this.getDirectiveLocation(), referenceName);
    }

    private void addDirectiveForDeprecated(Annotations annotationsForOperation, EnumValue enumValue) {
        if (this.deprecatedHelper != null && this.directives != null) {
            this.deprecatedHelper.transformDeprecatedToDirective(annotationsForOperation, this.directives.getDirectiveTypes().get(DotName.createSimple((String)"io.smallrye.graphql.api.Deprecated"))).ifPresent(deprecatedDirective -> {
                LOG.debug((Object)("Adding deprecated directive " + String.valueOf(deprecatedDirective) + " to enum value '" + enumValue.getValue() + "'"));
                enumValue.addDirectiveInstance(deprecatedDirective);
            });
        }
    }
}

