/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.model.Namespace;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;

public class NamespaceHelper {
    private NamespaceHelper() {
    }

    public static Optional<Namespace> getNamespace(AnnotationInstance graphQLApiAnnotation) {
        Optional<List<String>> names = NamespaceHelper.getNames(graphQLApiAnnotation);
        if (names.isPresent()) {
            Optional<String> description = NamespaceHelper.getDescription(graphQLApiAnnotation);
            Namespace group = new Namespace();
            group.setNames(names.get());
            group.setDescription((String)description.orElse(null));
            return Optional.of(group);
        }
        return Optional.empty();
    }

    private static Optional<List<String>> getNames(AnnotationInstance graphQLApiAnnotation) {
        String value;
        String[] namespaces;
        ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
        if (apiClass.hasDeclaredAnnotation(Annotations.NAMESPACE) && (namespaces = apiClass.declaredAnnotation(Annotations.NAMESPACE).value().asStringArray()).length > 0) {
            return Optional.of(List.of(namespaces));
        }
        if (apiClass.hasDeclaredAnnotation(Annotations.NAME) && !(value = apiClass.declaredAnnotation(Annotations.NAME).value().asString()).isEmpty()) {
            return Optional.of(List.of(value));
        }
        return Optional.empty();
    }

    private static Optional<String> getDescription(AnnotationInstance graphQLApiAnnotation) {
        String value;
        ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
        if (apiClass.hasDeclaredAnnotation(Annotations.DESCRIPTION) && !(value = apiClass.declaredAnnotation(Annotations.DESCRIPTION).value().asString()).isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

