/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.AbstractCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class TypeCreator
extends AbstractCreator {
    private final FieldCreator fieldCreator;

    public TypeCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator, OperationCreator operationCreator) {
        super(operationCreator, referenceCreator);
        this.fieldCreator = fieldCreator;
    }

    @Override
    protected void addFields(Type type, ClassInfo classInfo, Reference reference) {
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        HashMap<String, FieldInfo> allFields = new HashMap<String, FieldInfo>();
        ClassInfo c = classInfo;
        while (c != null) {
            if (InterfaceCreator.canAddInterfaceIntoScheme(c.toString())) {
                List classMethods = c.methods();
                allMethods.addAll(classMethods);
                allMethods.addAll(this.getAllInterfaceMethods(c, classMethods.stream().map(MethodInfo::toString).collect(Collectors.toSet())));
                for (FieldInfo fieldInfo : c.fields()) {
                    allFields.putIfAbsent(fieldInfo.name(), fieldInfo);
                }
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (MethodInfo methodInfo : allMethods) {
            FieldInfo fieldInfo;
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo)) continue;
            String fieldName = MethodHelper.getPropertyName(Direction.OUT, methodInfo.name());
            fieldInfo = (FieldInfo)allFields.remove(fieldName);
            this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((Type)type).addField(arg_0));
        }
        if (Objects.equals(classInfo.superName(), Classes.RECORD)) {
            for (FieldInfo fieldInfo : allFields.values()) {
                MethodInfo methodInfo = classInfo.method(fieldInfo.name(), new org.jboss.jandex.Type[0]);
                this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((Type)type).addField(arg_0));
            }
        } else {
            for (FieldInfo fieldInfo : allFields.values()) {
                this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, reference).ifPresent(arg_0 -> ((Type)type).addField(arg_0));
            }
        }
    }

    @Override
    protected ReferenceType referenceType() {
        return ReferenceType.TYPE;
    }

    private List<MethodInfo> getAllInterfaceMethods(ClassInfo classInfo, Set<String> methodMemory) {
        return classInfo.interfaceNames().stream().map(arg_0 -> ((IndexView)ScanningContext.getIndex()).getClassByName(arg_0)).filter(Objects::nonNull).flatMap(parentInterfaceInfo -> Stream.concat(parentInterfaceInfo.methods().stream().filter(method -> this.isNotGenericType((MethodInfo)method) && methodMemory.add(method.toString())), this.getAllInterfaceMethods((ClassInfo)parentInterfaceInfo, methodMemory).stream())).collect(Collectors.toList());
    }

    private boolean isNotGenericType(MethodInfo method) {
        return method.returnType().kind() != Type.Kind.TYPE_VARIABLE && method.returnType().kind() != Type.Kind.PARAMETERIZED_TYPE && method.parameterTypes().stream().allMatch(type -> type.kind() != Type.Kind.TYPE_VARIABLE && type.kind() != Type.Kind.PARAMETERIZED_TYPE);
    }

    @Override
    public String getDirectiveLocation() {
        return "OBJECT";
    }
}

