/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class RolesAllowedDirectivesHelper {
    public static final DirectiveType ROLES_ALLOWED_DIRECTIVE_TYPE = new DirectiveType();

    private static DirectiveArgument createArgument(String name, Reference reference) {
        DirectiveArgument arg = new DirectiveArgument();
        arg.setName(name);
        arg.setReference(reference);
        return arg;
    }

    public Optional<DirectiveInstance> transformRolesAllowedToDirectives(Annotations methodAnnotations, Annotations classAnnotations) {
        HashSet<DotName> annotationNames = new HashSet<DotName>(methodAnnotations.getAnnotationNames());
        if (classAnnotations != null) {
            annotationNames.addAll(classAnnotations.getAnnotationNames());
        }
        for (DotName annotationName : annotationNames) {
            if (!annotationName.equals((Object)DotName.createSimple((String)"jakarta.annotation.security.RolesAllowed"))) continue;
            DirectiveInstance directive = new DirectiveInstance();
            directive.setType(ROLES_ALLOWED_DIRECTIVE_TYPE);
            String value = this.getStringValue(methodAnnotations, annotationName, "value");
            if (value == null) {
                value = this.getStringValue(classAnnotations, annotationName, "value");
            }
            directive.setValue("value", (Object)value);
            return Optional.of(directive);
        }
        return Optional.empty();
    }

    private String getStringValue(Annotations annotations, DotName annotationName, String parameterName) {
        if (!annotations.containsKeyAndValidValue(annotationName)) {
            return null;
        }
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null && aValue.asStringArray().length != 0 ? aValue.asStringArray()[0] : null;
    }

    static {
        ROLES_ALLOWED_DIRECTIVE_TYPE.setName("rolesAllowed");
        ROLES_ALLOWED_DIRECTIVE_TYPE.setLocations(Set.of("FIELD_DEFINITION"));
        ROLES_ALLOWED_DIRECTIVE_TYPE.setDescription("Used to specify the role required to execute a given field or operation.");
        ROLES_ALLOWED_DIRECTIVE_TYPE.setRepeatable(false);
        ROLES_ALLOWED_DIRECTIVE_TYPE.addArgumentType(RolesAllowedDirectivesHelper.createArgument("value", Scalars.getStringScalar()));
    }
}

