/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Scalars {
    private static final Map<String, Reference> scalarMap = new HashMap<String, Reference>();
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String INTEGER = "Int";
    private static final String FLOAT = "Float";
    private static final String BIGINTEGER = "BigInteger";
    private static final String BIGDECIMAL = "BigDecimal";
    private static final String DATE = "Date";
    private static final String TIME = "Time";
    private static final String DATETIME = "DateTime";
    private static final String ID = "ID";
    private static final String PERIOD = "Period";
    private static final String DURATION = "Duration";

    private Scalars() {
    }

    public static boolean isScalar(String className) {
        return scalarMap.containsKey(className);
    }

    public static Reference getScalar(String className) {
        return scalarMap.get(className);
    }

    public static Reference getIDScalar(String className) {
        return new Reference(className, ID, ReferenceType.SCALAR);
    }

    private static void populateScalar(String className, String scalarName) {
        scalarMap.put(className, new Reference(className, scalarName, ReferenceType.SCALAR));
    }

    static {
        Scalars.populateScalar(Character.TYPE.getName(), STRING);
        Scalars.populateScalar(Character.class.getName(), STRING);
        Scalars.populateScalar(String.class.getName(), STRING);
        Scalars.populateScalar(UUID.class.getName(), STRING);
        Scalars.populateScalar(URL.class.getName(), STRING);
        Scalars.populateScalar(URI.class.getName(), STRING);
        Scalars.populateScalar(Boolean.class.getName(), BOOLEAN);
        Scalars.populateScalar(Boolean.TYPE.getName(), BOOLEAN);
        Scalars.populateScalar(Integer.class.getName(), INTEGER);
        Scalars.populateScalar(Integer.TYPE.getName(), INTEGER);
        Scalars.populateScalar(Short.class.getName(), INTEGER);
        Scalars.populateScalar(Short.TYPE.getName(), INTEGER);
        Scalars.populateScalar(Byte.class.getName(), INTEGER);
        Scalars.populateScalar(Byte.TYPE.getName(), INTEGER);
        Scalars.populateScalar(Float.class.getName(), FLOAT);
        Scalars.populateScalar(Float.TYPE.getName(), FLOAT);
        Scalars.populateScalar(Double.class.getName(), FLOAT);
        Scalars.populateScalar(Double.TYPE.getName(), FLOAT);
        Scalars.populateScalar(BigInteger.class.getName(), BIGINTEGER);
        Scalars.populateScalar(Long.class.getName(), BIGINTEGER);
        Scalars.populateScalar(Long.TYPE.getName(), BIGINTEGER);
        Scalars.populateScalar(BigDecimal.class.getName(), BIGDECIMAL);
        Scalars.populateScalar(LocalDate.class.getName(), DATE);
        Scalars.populateScalar(Date.class.getName(), DATE);
        Scalars.populateScalar(LocalTime.class.getName(), TIME);
        Scalars.populateScalar(Time.class.getName(), TIME);
        Scalars.populateScalar(OffsetTime.class.getName(), TIME);
        Scalars.populateScalar(LocalDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(java.util.Date.class.getName(), DATETIME);
        Scalars.populateScalar(Timestamp.class.getName(), DATETIME);
        Scalars.populateScalar(ZonedDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(OffsetDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(Duration.class.getName(), DURATION);
        Scalars.populateScalar(Period.class.getName(), PERIOD);
        Scalars.populateScalar(ID, ID);
    }
}

