/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.schema.model.Wrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Field
implements Serializable {
    private String methodName;
    private String propertyName;
    private String name;
    private String description;
    private Reference reference;
    private Wrapper wrapper = null;
    private Transformation transformation = null;
    private AdaptTo adaptTo = null;
    private AdaptWith adaptWith = null;
    private String defaultValue = null;
    private boolean notNull = false;
    private List<DirectiveInstance> directiveInstances;

    public Field() {
        this.directiveInstances = new ArrayList<DirectiveInstance>();
    }

    public Field(String methodName, String propertyName, String name, Reference reference) {
        this.methodName = methodName;
        this.propertyName = propertyName;
        this.name = name;
        this.reference = reference;
        this.directiveInstances = new ArrayList<DirectiveInstance>();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean hasWrapper() {
        return this.wrapper != null;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public boolean hasTransformation() {
        return this.transformation != null;
    }

    public AdaptTo getAdaptTo() {
        return this.adaptTo;
    }

    public void setAdaptTo(AdaptTo adaptTo) {
        this.adaptTo = adaptTo;
    }

    public boolean isAdaptingTo() {
        return this.adaptTo != null;
    }

    public AdaptWith getAdaptWith() {
        return this.adaptWith;
    }

    public void setAdaptWith(AdaptWith adaptWith) {
        this.adaptWith = adaptWith;
    }

    public boolean isAdaptingWith() {
        return this.adaptWith != null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasDirectiveInstances() {
        return this.directiveInstances != null && !this.directiveInstances.isEmpty();
    }

    public List<DirectiveInstance> getDirectiveInstances() {
        return this.directiveInstances;
    }

    public void setDirectiveInstances(List<DirectiveInstance> directiveInstances) {
        this.directiveInstances = directiveInstances;
    }

    public void addDirectiveInstances(List<DirectiveInstance> directiveInstances) {
        if (directiveInstances != null) {
            this.directiveInstances.addAll(directiveInstances);
        }
    }

    public void addDirectiveInstance(DirectiveInstance directiveInstance) {
        this.directiveInstances.add(directiveInstance);
    }

    public String toString() {
        return "Field{methodName=" + this.methodName + ", propertyName=" + this.propertyName + ", name=" + this.name + ", description=" + this.description + ", reference=" + String.valueOf(this.reference) + ", wrapper=" + String.valueOf(this.wrapper) + ", transformation=" + String.valueOf(this.transformation) + ", adaptTo=" + String.valueOf(this.adaptTo) + ", adaptWith=" + String.valueOf(this.adaptWith) + ", defaultValue=" + this.defaultValue + ", notNull=" + this.notNull + ", directiveInstances=" + String.valueOf(this.directiveInstances) + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.methodName);
        hash = 73 * hash + Objects.hashCode(this.propertyName);
        hash = 73 * hash + Objects.hashCode(this.name);
        hash = 73 * hash + Objects.hashCode(this.description);
        hash = 73 * hash + Objects.hashCode(this.reference);
        hash = 73 * hash + Objects.hashCode(this.wrapper);
        hash = 73 * hash + Objects.hashCode(this.transformation);
        hash = 73 * hash + Objects.hashCode(this.adaptTo);
        hash = 73 * hash + Objects.hashCode(this.adaptWith);
        hash = 73 * hash + Objects.hashCode(this.defaultValue);
        hash = 73 * hash + (this.notNull ? 1 : 0);
        hash = 73 * hash + Objects.hashCode(this.directiveInstances);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (this.notNull != other.notNull) {
            return false;
        }
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        if (!Objects.equals(this.reference, other.reference)) {
            return false;
        }
        if (!Objects.equals(this.wrapper, other.wrapper)) {
            return false;
        }
        if (!Objects.equals(this.transformation, other.transformation)) {
            return false;
        }
        if (!Objects.equals(this.adaptTo, other.adaptTo)) {
            return false;
        }
        if (!Objects.equals(this.adaptWith, other.adaptWith)) {
            return false;
        }
        return Objects.equals(this.directiveInstances, other.directiveInstances);
    }
}

