/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.datafetcher.helper.PartialResultHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import org.dataloader.BatchLoaderWithContext;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractDataFetcher<K, T>
implements DataFetcher<T>,
BatchLoaderWithContext<K, T> {
    protected Operation operation;
    protected FieldHelper fieldHelper;
    protected ReflectionHelper reflectionHelper;
    protected PartialResultHelper partialResultHelper;
    protected ArgumentHelper argumentHelper;
    protected EventEmitter eventEmitter;
    protected BatchLoaderHelper batchLoaderHelper;

    public AbstractDataFetcher(Operation operation, Config config) {
        this.operation = operation;
        this.eventEmitter = EventEmitter.getInstance(config);
        this.fieldHelper = new FieldHelper((Field)operation);
        this.reflectionHelper = new ReflectionHelper(operation, this.eventEmitter);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.partialResultHelper = new PartialResultHelper();
        this.batchLoaderHelper = new BatchLoaderHelper();
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        GraphQLContext graphQLContext = (GraphQLContext)dfe.getContext();
        SmallRyeContext context = ((SmallRyeContext)graphQLContext.get((Object)"context")).withDataFromFetcher(dfe, (Field)this.operation);
        graphQLContext.put((Object)"context", (Object)context);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)graphQLContext);
        this.eventEmitter.fireBeforeDataFetch(context);
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            T t = this.invokeAndTransform(dfe, (DataFetcherResult.Builder<Object>)resultBuilder, transformedArguments);
            return t;
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.partialResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch(context);
        }
        return this.invokeFailure((DataFetcherResult.Builder<Object>)resultBuilder);
    }

    protected abstract <T> T invokeAndTransform(DataFetchingEnvironment var1, DataFetcherResult.Builder<Object> var2, Object[] var3) throws AbstractDataFetcherException, Exception;

    protected abstract <T> T invokeFailure(DataFetcherResult.Builder<Object> var1);
}

