/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.eclipse.microprofile.graphql.GraphQLException;

public class UniDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public UniDataFetcher(Operation operation, Config config) {
        super(operation, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws AbstractDataFetcherException, Exception {
        SmallRyeContext context = (SmallRyeContext)((GraphQLContext)dfe.getContext()).get((Object)"context");
        try {
            SmallRyeContext.setContext(context);
            Uni uni = (Uni)this.reflectionHelper.invoke(transformedArguments);
            CompletableFuture completableFuture = uni.onItemOrFailure().transform((result, throwable) -> {
                if (throwable != null) {
                    this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), (Throwable)throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)throwable;
                        this.partialResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                    } else {
                        if (throwable instanceof Exception) {
                            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable);
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformResponse(result));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult(resultBuilder, dfe);
                    }
                }
                return resultBuilder.build();
            }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
            return (T)completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }

    @Override
    protected <T> T invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (T)Uni.createFrom().item(() -> resultBuilder.build()).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }

    public CompletionStage<List<T>> load(List<K> keys, BatchLoaderEnvironment ble) {
        Object[] arguments = this.batchLoaderHelper.getArguments(keys, ble);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return ((Uni)this.reflectionHelper.invokePrivileged(tccl, arguments)).runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
    }
}

